% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{calib_ests}
\alias{calib_ests}
\title{Return calibrated estimates of studies' true effect sizes}
\usage{
calib_ests(yi, sei, method = "DL")
}
\arguments{
\item{yi}{Vector of study-level point estimates}

\item{sei}{Vector of study-level standard errors}

\item{method}{Estimation method for mean and variance of true effects (passed to \code{metafor::rma.uni})}
}
\description{
Returns estimates of the true effect in each study based on the methods of Wang & Lee (2019).
Unlike the point estimates themselves, these "calibrated" estimates have been
appropriately shrunk to correct the overdispersion that arises due to the studies' finite sample sizes.
By default, this function uses Dersimonian-Laird moments-based estimates of the mean and variance of the true
effects, as Wang & Lee (2019) recommended.
}
\examples{
d = metafor::escalc(measure="RR", ai=tpos, bi=tneg,
                     ci=cpos, di=cneg, data=metafor::dat.bcg)

# calculate calibrated estimates
d$calib = calib_ests( yi = d$yi,
                      sei = sqrt(d$vi) )

# look at 5 studies with the largest calibrated estimates
d = d[ order(d$calib, decreasing = TRUE), ]
d$trial[1:5]

# look at kernel density estimate of calibrated estimates
plot(density(d$calib))
}
\references{
1. Wang C-C & Lee W-C (2019). A simple method to estimate prediction intervals and
predictive distributions: Summarizing meta-analyses
beyond means and confidence intervals. Research Synthesis Methods.
}
