% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_stan.R
\name{meta_stan}
\alias{meta_stan}
\title{Fitting a meta-analysis model using Stan}
\usage{
meta_stan(ntrt = NULL, nctrl = NULL, rtrt = NULL, rctrl = NULL,
  model = "BNHM1", mu_prior = c(0, 10), theta_prior = NULL,
  tau_prior = 0.5, tau_prior_dist = "half-normal", delta = NULL,
  chains = 4, iter = 2000, warmup = 1000, adapt_delta = 0.95)
}
\arguments{
\item{ntrt}{Number of subjects in treatment arm}

\item{nctrl}{Number of subjects in control arm}

\item{rtrt}{Number of events in treatment arm}

\item{rctrl}{Number of events in contrl arm}

\item{model}{A string specifying the model used. Available options are `FE` (fixed-effect model
using binomial lielihood) `BNHM1` (Model 4 from \emph{Jackson
et al (2018)}), `BNHM2` (Model 2 from \emph{Jackson et al (2018)}), and `Beta-binomial` (Beta-binomial
model from \emph{Kuss (2014)}). Default is `BNHM1`.}

\item{mu_prior}{A numerical vector specifying the parameter of the normal prior
density for baseline risks, first value is parameter for mean, second is for variance.
Default is c(0, 10).}

\item{theta_prior}{A numerical vector specifying the parameter of the normal prior
density for treatment effect estimate, first value is parameter for mean, second
is for variance. Default is NULL.}

\item{tau_prior}{A numerical value specifying the standard dev. of the prior density
for heterogenety stdev. Default is 0.5.}

\item{tau_prior_dist}{A string specifying the prior density for the heterogeneity standard deviation,
option is `half-normal` for half-normal prior, `uniform` for uniform prior, `half-cauchy` for
half-cauchy prior.}

\item{delta}{A numerical value specifying the upper bound of the a priori interval for
treatment effect on odds ratio scale \emph{Guenhan et al (2018)}. This is used to calculate
a normal weakly informative prior
for theta. Thus when this argument is pecified, `theta` should be left empty. Default is NULL.}

\item{chains}{A positive integer specifying the number of Markov chains.
The default is 4.}

\item{iter}{A positive integer specifying the number of iterations for each chain
(including warmup). The default is 2000.}

\item{warmup}{A positive integer specifying the number of warmup (aka burnin)
iterations per chain. The default is 1000.}

\item{adapt_delta}{A numerical value specfying the target average proposal acceptance
probability for adaptation. See Stan manual for details. Default is 0.95. In general
you should not need to change adapt_delta unless you see a warning message about
divergent transitions, in which case you can increase adapt_delta from the
default to a value closer to 1 (e.g. from 0.95 to 0.99, or from 0.99 to 0.999, etc).}
}
\value{
an object of class `stanfit` returned by `rstan::sampling`
}
\description{
`meta_stan` fits a meta-analysis model using Stan.
}
\examples{
\donttest{
data('dat.Crins2014', package = "MetaStan")
## Subset of dataset where PTLD outcomes available
dat.Crins2014.PTLD = subset(dat.Crins2014, is.finite(exp.PTLD.events))
## Fitting a Binomial-Normal Hierarchial model using vague priors for theta
bnhm.vague.PTLD.stan  <- meta_stan(ntrt = dat.Crins2014.PTLD$exp.total,
                                   nctrl = dat.Crins2014.PTLD$cont.total,
                                   rtrt = dat.Crins2014.PTLD$exp.PTLD.events,
                                   rctrl = dat.Crins2014.PTLD$cont.PTLD.event,
                                   mu_prior = c(0, 10), theta_prior = c(0, 100),
                                   tau_prior =  0.5)
## Obatining a small summary
print(bnhm.vague.PTLD.stan)
## Extract the rstan fit for post-processing, eg convergence diagnostics
bnhm.vague.PTLD.stanfit = bnhm.vague.PTLD.stan$fit
 ## see `?rstan::sampling` for for post-processing of the `stanfit` object
## Fitting a Binomial-Normal Hierarchial model using WIP for theta
bnhm.wip.PTLD.stan  <- meta_stan(ntrt = dat.Crins2014.PTLD$exp.total,
                                   nctrl = dat.Crins2014.PTLD$cont.total,
                                   rtrt = dat.Crins2014.PTLD$exp.PTLD.events,
                                   rctrl = dat.Crins2014.PTLD$cont.PTLD.event,
                                   mu_prior = c(0, 10),
                                   theta_prior = c(0, 2.82),
                                   tau_prior =  0.5)
## Fitting a fixed-effect Binomial model using vague priors for theta
bm.vague.PTLD.stan  <- meta_stan(ntrt = dat.Crins2014.PTLD$exp.total,
                                   nctrl = dat.Crins2014.PTLD$cont.total,
                                   rtrt = dat.Crins2014.PTLD$exp.PTLD.events,
                                   rctrl = dat.Crins2014.PTLD$cont.PTLD.event,
                                   mu_prior = c(0, 10), theta_prior = c(0, 100),
                                   model = "FE")

## Fitting a Beta-binomial model using vague priors
bnhm.wip.PTLD.stan  <- meta_stan(ntrt = dat.Crins2014.PTLD$exp.total,
                                   nctrl = dat.Crins2014.PTLD$cont.total,
                                   rtrt = dat.Crins2014.PTLD$exp.PTLD.events,
                                   rctrl = dat.Crins2014.PTLD$cont.PTLD.event,
                                   model = "Beta-binomial")
}

}
\references{
Guenhan BK, Roever C, Friede T. Meta-analysis of few studies involving
rare events \emph{arXiv preprint} 2018;https://arxiv.org/abs/1809.04407.
\emph{Stat Med} 2018;37:1059--1085.

Jackson D, Law M, Stijnen T, Viechtbauer W, White IR. A comparison of 7
random-effects models for meta-analyses that estimate the summary odds ratio.
\emph{Stat Med} 2018;37:1059--1085.

Kuss O, Hoyer A and Solms A. Meta-analysis for diagnostic accuracy
studies: a new statistical model using beta-binomial distributions and bivariate copulas.
\emph{Stat Med}, 2014; 33:17--30. doi:10.1002/sim.5909
}
