% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{MetaRVMConfig}
\alias{MetaRVMConfig}
\title{MetaRVM Configuration Class}
\description{
R6 class to handle MetaRVM configuration data with validation and methods.
This class encapsulates all configuration parameters needed for MetaRVM simulations,
providing methods for parameter access, validation, and introspection.
}
\details{
The MetaRVMConfig class stores parsed configuration data from YAML files and provides
structured access to simulation parameters. It automatically validates configuration
completeness and provides convenient methods for accessing demographic categories,
population mappings, and other simulation settings.
}
\examples{
# Initialize from YAML file
example_config <- system.file("extdata", "example_config.yaml", package = "MetaRVM")
config <- MetaRVMConfig$new(example_config)

# Access parameters
config$get("N_pop")
config$get("start_date")

# Get demographic categories
ages <- config$get_age_categories()
races <- config$get_race_categories()
zones <- config$get_zones()

}
\author{
Arindam Fadikar
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{config_file}}{Path to the original YAML config file (if applicable)}

\item{\code{config_data}}{List containing all parsed configuration parameters}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MetaRVMConfig-new}{\code{MetaRVMConfig$new()}}
\item \href{#method-MetaRVMConfig-get}{\code{MetaRVMConfig$get()}}
\item \href{#method-MetaRVMConfig-get_all}{\code{MetaRVMConfig$get_all()}}
\item \href{#method-MetaRVMConfig-list_parameters}{\code{MetaRVMConfig$list_parameters()}}
\item \href{#method-MetaRVMConfig-parameter_summary}{\code{MetaRVMConfig$parameter_summary()}}
\item \href{#method-MetaRVMConfig-set}{\code{MetaRVMConfig$set()}}
\item \href{#method-MetaRVMConfig-print}{\code{MetaRVMConfig$print()}}
\item \href{#method-MetaRVMConfig-get_pop_map}{\code{MetaRVMConfig$get_pop_map()}}
\item \href{#method-MetaRVMConfig-get_age_categories}{\code{MetaRVMConfig$get_age_categories()}}
\item \href{#method-MetaRVMConfig-get_race_categories}{\code{MetaRVMConfig$get_race_categories()}}
\item \href{#method-MetaRVMConfig-get_zones}{\code{MetaRVMConfig$get_zones()}}
\item \href{#method-MetaRVMConfig-clone}{\code{MetaRVMConfig$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMConfig-new"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMConfig-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new MetaRVMConfig object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMConfig$new(input)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Either a file path (character) or parsed config list}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
New MetaRVMConfig object (invisible)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMConfig-get"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMConfig-get}{}}}
\subsection{Method \code{get()}}{
Get a configuration parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMConfig$get(param)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param}}{Parameter name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The requested parameter value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMConfig-get_all"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMConfig-get_all}{}}}
\subsection{Method \code{get_all()}}{
Get all configuration parameters as a list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMConfig$get_all()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named list of all configuration parameters
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMConfig-list_parameters"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMConfig-list_parameters}{}}}
\subsection{Method \code{list_parameters()}}{
List all available parameter names
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMConfig$list_parameters()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector of parameter names
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMConfig-parameter_summary"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMConfig-parameter_summary}{}}}
\subsection{Method \code{parameter_summary()}}{
Show summary of parameter types and sizes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMConfig$parameter_summary()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Data frame with parameter information
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMConfig-set"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMConfig-set}{}}}
\subsection{Method \code{set()}}{
Set a configuration parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMConfig$set(param, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param}}{Character string. Parameter name to set}

\item{\code{value}}{The value to assign to the parameter}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self (invisible) for method chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMConfig-print"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMConfig-print}{}}}
\subsection{Method \code{print()}}{
Print summary of configuration
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMConfig$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Self (invisible)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMConfig-get_pop_map"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMConfig-get_pop_map}{}}}
\subsection{Method \code{get_pop_map()}}{
Get population mapping data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMConfig$get_pop_map()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
data.table containing population mapping with demographic categories
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMConfig-get_age_categories"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMConfig-get_age_categories}{}}}
\subsection{Method \code{get_age_categories()}}{
Get available age categories
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMConfig$get_age_categories()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector of unique age categories, or NULL if no population mapping available
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMConfig-get_race_categories"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMConfig-get_race_categories}{}}}
\subsection{Method \code{get_race_categories()}}{
Get available race categories
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMConfig$get_race_categories()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector of unique race categories, or NULL if no population mapping available
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMConfig-get_zones"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMConfig-get_zones}{}}}
\subsection{Method \code{get_zones()}}{
Get available zones
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMConfig$get_zones()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector of unique zone identifiers, or NULL if no population mapping available
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMConfig-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMConfig-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMConfig$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
