% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predvalPlot.R
\name{predvalPlot}
\alias{predvalPlot}
\title{Plot positive and negative predictive values across different prevalences}
\usage{
predvalPlot(sens, spec, nsteps=1000, title=NULL, rounding=2)
}
\arguments{
\item{sens}{the sensitivity of the prediction}

\item{spec}{the specificity of the prediction}

\item{nsteps}{the number of steps between prevalence 0\% and 100\% (i.e. the number of steps in the X-axis) (default: 1000)}

\item{title}{title of the plot (if left blank, it will just indicate the input sensitivity and specificity)}

\item{rounding}{number of significant digits for displaying the sensitivity, specificity, PPV, and NPV (default: 2)}
}
\value{
Plotly plot of predictive values vs. prevalence
}
\description{
Positive and negative predictive values (PPV and NPV) are two diagnostic statistics that change depending on the prevalence, so if you don't have a discrete prevalence to work with
this function can create a plot that shows the positive and negative predictive values across all possible prevalences (as long as you have already calculated the sensitivity and specificity).
}
\examples{
predvalPlot(sens = 0.9, spec = 0.8)
}
\author{
Lara Murphy, Aditya M. Rao
}
