% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mr_hetpen-methods.R
\docType{methods}
\name{mr_hetpen}
\alias{mr_hetpen}
\alias{mr_hetpen,MRInput-method}
\title{Heterogeneity-penalized method}
\usage{
mr_hetpen(object, prior = 0.5, CIMin = -1, CIMax = 1,
  CIStep = 0.001, alpha = 0.05)

\S4method{mr_hetpen}{MRInput}(object, prior = 0.5, CIMin = -1,
  CIMax = 1, CIStep = 0.001, alpha = 0.05)
}
\arguments{
\item{object}{An \code{MRInput} object.}

\item{prior}{The prior probability of a genetic variant being a valid instrument (default is 0.5).}

\item{CIMin}{The smallest value to use in the search to find the confidence interval (default is -1).}

\item{CIMax}{The largest value to use in the search to find the confidence interval (default is +1).}

\item{CIStep}{The step size to use in the search to find the confidence interval (default is 0.001). The confidence interval is determined by a grid search algorithm. Using the default settings, we calculate the likelihood at all values from -1 to +1 increasing in units of 0.001. If this range is too large or the step size is too small, then the grid search algorithm will take a long time to converge.}

\item{alpha}{The significance level used to calculate the confidence interval. The default value is 0.05.}
}
\value{
The output from the function is an \code{MRHetPen} object containing:

 \item{Exposure}{A character string giving the name given to the exposure.}
 \item{Outcome}{A character string giving the name given to the outcome.}
 \item{Prior}{The value of the bandwidth factor.}
 \item{Estimate}{The value of the causal estimate.}
 \item{CIRange}{The range of values in the confidence interval based on a grid search between the minimum and maximum values for the causal effect provided.}
 \item{CILower}{The lower limit of the confidence interval. If the confidence interval contains multiple ranges, then lower limits of all ranges will be reported.}
 \item{CIUpper}{The upper limit of the confidence interval. If the confidence interval contains multiple ranges, then upper limits of all ranges will be reported.}
 \item{CIMin}{The smallest value used in the search to find the confidence interval.}
 \item{CIMax}{The largest value used in the search to find the confidence interval.}
 \item{CIStep}{The step size used in the search to find the confidence interval.}
 \item{Alpha}{The significance level used when calculating the confidence intervals.}
 \item{SNPs}{The number of genetic variants (SNPs) included in the analysis.}
}
\description{
Heterogeneity-penalized model-averaging method for efficient modal-based estimation.
}
\details{
This method was developed as a more efficient version of the mode-based estimation method of Hartwig et al. It proceeds by evaluating weights for all subsets of genetic variants (excluding the null set and singletons). Subsets receive greater weight if they include more variants, but are severely downweighted if the variants in the subset have heterogeneous causal estimates. As such, the method will identify the subset with the largest number (by weight) of variants having similar causal estimates.

Confidence intervals are evaluated by calculating a log-likelihood function, and finding all points within a given vertical distance of the maximum of the log-likelihood function (which is the causal estimate). As such, if the log-likelihood function is multimodal, then the confidence interval may include multiple disjoint ranges. This may indicate the presence of multiple causal mechanisms by which the exposure may influence the outcome with different magnitudes of causal effect. As the confidence interval is determined by a grid search, care must be taken when chosing the minimum (\code{CIMin}) and maximum (\code{CIMax}) values in the search, as well as the step size (\code{CIStep}). The default values will not be suitable for all applications.

The method should give consistent estimates as the sample size increases if a weighted plurality of the genetic variants are valid instruments. This means that the largest group of variants with the same causal estimate in the asymptotic limit are the valid instruments.

The current implementation of the method evaluates a weight and an estimate for each of the subsets of genetic variants. This means that the method complexity doubles for each additional genetic variant included in the analysis. Currently, the method provides a warning message when used with 25+ variants, and fails to run with 30+.
}
\examples{
mr_hetpen(mr_input(bx = ldlc[1:10], bxse = ldlcse[1:10], by = chdlodds[1:10],
   byse = chdloddsse[1:10]), CIMin = -1, CIMax = 5, CIStep = 0.01)

}
\references{
Stephen Burgess, Verena Zuber, Apostolos Gkatzionis, Christopher N Foley. Improving on a modal-based estimation method: model averaging for consistent and efficient estimation in Mendelian randomization when a plurality of candidate instruments are valid. bioRxiv 2017. doi: 10.1101/175372.
}
