% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2genabel.R
\name{mkGenABELtped}
\alias{mkGenABELtped}
\title{generate a PLINK TPED file for GenABEL}
\usage{
mkGenABELtped(prefix, markers = NULL, mapno = 0, envir)
}
\arguments{
\item{prefix}{prefix for .tped file name}

\item{markers}{markers selected to be in output file}

\item{mapno}{specify which map index to use for genetic distances}

\item{envir}{'environment' containing SQLite database and other globals}
}
\value{
None
}
\description{
Generate a PLINK TPED file from the specified Mega2 SQLite database.  The file is named "prefix".tped
 If the markers argument is.null(), the entire envir$markers set is include; otherwise the markers argument MUST
 be a subset of the envir$markers data.frame -- same columns, but fewer rows.
}
\examples{
\dontrun{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = read.Mega2DB(db)
mkGenABELtped("foo", NULL, 0, ENV)
}
}
\keyword{internal}
