% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertStateLegislativeDistricts.R
\name{convertStateLegislativeDistricts}
\alias{convertStateLegislativeDistricts}
\title{Convert US state legislative districts shapefile}
\usage{
convertStateLegislativeDistricts(
  stateCode,
  house = "Upper",
  nameOnly = FALSE,
  simplify = TRUE
)
}
\arguments{
\item{stateCode}{ISO 3166-2 alpha-2 state code.}

\item{house}{Character specifying either "Upper" or "Lower" house.}

\item{nameOnly}{Logical specifying whether to only return the name without
creating the file.}

\item{simplify}{Logical specifying whether to create "_05", _02" and "_01"
versions of the file that are simplified to 5\%, 2\% and 1\%.}
}
\value{
Name of the dataset being created.
}
\description{
Create a SpatialPolygonsDataFrame for US State Legislative Districts
of a specified state
}
\details{
A US State Legislative District shapefile is downloaded and converted
to a SpatialPolygonsDataFrame with additional columns of data. The resulting
file will be created in the spatial data directory which is set with
\code{setSpatialDataDir()}.
}
\note{
From the source documentation:

The 2019 cartographic boundary shapefiles are simplified representations of
selected geographic areas from the U.S. Census Bureau's Master Address File /
Topologically Integrated Geographic Encoding and Referencing (MAF/TIGER)
Database (MTDB). These boundary files are specifically designed for small-scale
thematic mapping. When possible, generalization is performed with the intent
to maintain the hierarchical relationships among geographies and to maintain
the alignment of geographies within a file set for a given year. Geographic
areas may not align with the same areas from another year. Some geographies
are available as nation-based files while others are available only as state-
based files.

SLDL stands for State Legislative District Lower Chamber...

SLDU stands for State Legislative District Upper Chamber.

State Legislative Districts (SLDs) are the areas from which members are elected to state
legislatures. The SLDs embody the upper (senate) and lower (house) chambers of
the state legislature. Nebraska has a unicameral legislature and the District
of Columbia has a single council, both of which the Census Bureau treats as
upper-chamber legislative areas for the purpose of data presentation; there are
no data by SLDL for either Nebraska or the District of Columbia. A unique three-
character census code, identified by state participants, is assigned to each
SLD within a state. In Connecticut, Illinois, Louisiana, Maine, Maryland,
Massachusetts, Michigan, Ohio, and Puerto Rico, the Redistricting Data Program
(RDP) participant did not define the SLDs to cover all of the state or state
equivalent area. In these areas with no SLDs defined, the code "ZZZ" has been
assigned, which is treated as a single SLD for purposes of data presentation.

The boundaries of the 2018 state legislative districts were provided by state-
level participants through the RDP and reflect the districts used to elect
members in or prior to the November 2018 election

These files were specifically created to support small-scale thematic mapping.
To improve the appearance of shapes at small scales, areas are represented with
fewer vertices than detailed TIGER/Line Shapefiles. Cartographic boundary files
take up less disk space than their ungeneralized counterparts. Cartographic
boundary files take less time to render on screen than TIGER/Line Shapefiles.
You can join this file with table data downloaded from American FactFinder by
using the AFFGEOID field in the cartographic boundary file. If detailed boundaries
are required, please use the TIGER/Line Shapefiles instead of the generalized
cartographic boundary files
}
\references{
\url{https://www.census.gov/geographies/mapping-files/time-series/geo/cartographic-boundary.html}
}
\seealso{
setSpatialDataDir
}
\keyword{datagen}
