\name{estimateEffects}
\alias{estimateEffects}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Estimate Effects on the Frontier
}
\description{
  \code{estimateEffects()} is used to estimate the effect of the
    treatment along the entire frontier. 
}
\usage{
estimateEffects(frontier.object, formula, prop.estimated = 1)
}
\arguments{
  \item{frontier.object}{
    An object generated by \code{makeFrontier()}.
  }
  \item{formula}{
    An object of class formula (or one that can be
    coerced to that class). This will be passed to
    \code{lm()}.
  }
  \item{prop.estimated}{
    The proportion of points on the frontier to estimate.
    By default, 100\% of the points on the frontier are
    estimated. To estimate less than 100\% of the points,
    pass the proportion to be estimated to prop.estimated
    (for example, .6 to estimate 60\% of the points).
  }
}
\examples{
data(lalonde)

# set seed for sampling a small data set for this example
set.seed(02139) 
lalonde <- lalonde[c(which(lalonde$treat == 1),
                     sample(which(lalonde$treat == 0), 500)), ]

match.on <- colnames(lalonde)[!(colnames(lalonde) \%in\% c('re78',
                                'treat'))]

my.frontier <- makeFrontier(dataset = lalonde,
                            treatment = 'treat',
                            outcome = 're78',
                            match.on = match.on)
my.estimates <- estimateEffects(my.frontier, 're78 ~ treat',
                                prop.estimated = .05)
}