% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance_ratio.R
\name{compute_res_var_ratio}
\alias{compute_res_var_ratio}
\title{Compute ratio of variances of residuals for covariates}
\usage{
compute_res_var_ratio(
  original_data = NULL,
  mi_obj = NULL,
  type_vec = NULL,
  discard = FALSE
)
}
\arguments{
\item{original_data}{A data frame containing original data}

\item{mi_obj}{A matchit object derived from MatchIt pacakge}

\item{type_vec}{A vector specifying covariate types, valid values: 'ordinal',
'3', 3; 'binary', '2', 2; 'continuous', '1', 1; 'excluded', '0', 0, NA. The
last one means not to compute the ratio for this covariate. The length of
this vector should be the same as that of covariate vector used in
propensity score estimation.}

\item{discard}{A logical value. TRUE means some observations are discarded
before matching (with respect to discarded argument in matchit function),
then the ratio before matching is based on the data after discard; FALSE
means no observation is discarded before matching, then the ratio before
matching is based on the original intact data.}
}
\description{
This function computes the ratio of variances of residuals for covariates,
which was proposed by Rubin (2001). Applicable covariate types include
continuous, binary and ordinal. Multinomial variables are not applicable to
this function due to the absence of single residual. Usually a k-category
multinomial variable will have k-1 residuals if multinomial logistic or
probit regression is applied. For continuous variable, glm(family= gaussian)
is used; for binary variable, glm(family= binomial(link= logit)) is used;
for ordinal variable, MASS::polr(method = "logistic") is used, then single
residual is obtained by using sure::resids().
}
\examples{
 m_out <- MatchIt::matchit(treat ~ re74 + re75 + age + educ + hispan + black,
  data = MatchIt::lalonde, method = "nearest")
# use parse_formula() to check grouping variable and covariates
 parse_formula(m_out)
 compute_res_var_ratio(original_data = MatchIt::lalonde, mi_obj =
  m_out, type_vec = c(0, 1, 1, 1, 2, 2))
}
\references{
Rubin, D. B. (2001). Using propensity scores to help design
observational studies: Application to the tobacco litigation. \emph{Health
Services and Outcomes Research Methodology, 2}(3/4), 169-188.
https://doi.org/10.1023/A:1020363010465
}
\seealso{
parse_formula() compute_var_ratio()
}
\keyword{ratio}
\keyword{residual}
\keyword{variance}
