% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand_modelgrid}
\alias{expand_modelgrid}
\alias{expand_modelgrid.formula}
\alias{expand_modelgrid.matrix}
\alias{expand_modelgrid.ModelFrame}
\alias{expand_modelgrid.recipe}
\alias{expand_modelgrid.TunedModel}
\title{Model Tuning Grid Expansion}
\usage{
expand_modelgrid(...)

\method{expand_modelgrid}{formula}(formula, data, model, info = FALSE, ...)

\method{expand_modelgrid}{matrix}(x, y, model, info = FALSE, ...)

\method{expand_modelgrid}{ModelFrame}(input, model, info = FALSE, ...)

\method{expand_modelgrid}{recipe}(input, model, info = FALSE, ...)

\method{expand_modelgrid}{TunedModel}(model, ..., info = FALSE)
}
\arguments{
\item{...}{arguments passed from the generic function to its methods and from
the \code{TunedModel} method to others.  The first arguments of
\code{expand_modelgrid} methods are positional and, as such, must be
given first in calls to them.}

\item{formula, data}{\link[=formula]{formula} defining the model predictor and
response variables and a \link[=data.frame]{data frame} containing them.}

\item{model}{\code{\link{TunedModel}} object.  Can be given first followed by
any of the variable specifications.}

\item{info}{logical indicating whether to return model-defined grid
construction information rather than the grid values.}

\item{x, y}{\link{matrix} and object containing predictor and response
variables.}

\item{input}{\link[=inputs]{input} object defining and containing the model
predictor and response variables.}
}
\value{
A data frame of parameter values or \code{NULL} if data are required
for construction of the grid but not supplied.
}
\description{
Expand a model grid of tuning parameter values.
}
\details{
The \code{expand_modelgrid} function enables manual extraction and viewing of
grids created automatically when a \code{\link{TunedModel}} is fit.
}
\examples{
expand_modelgrid(TunedModel(GBMModel, grid = 5))

expand_modelgrid(TunedModel(GLMNetModel, grid = c(alpha = 5, lambda = 10)),
                 sale_amount ~ ., data = ICHomes)

gbm_grid <- ParameterGrid(
  n.trees = dials::trees(),
  interaction.depth = dials::tree_depth(),
  size = 5
)
expand_modelgrid(TunedModel(GBMModel, grid = gbm_grid))

rf_grid <- ParameterGrid(
  mtry = dials::mtry(),
  nodesize = dials::max_nodes(),
  size = c(3, 5)
)
expand_modelgrid(TunedModel(RandomForestModel, grid = rf_grid),
                 sale_amount ~ ., data = ICHomes)

}
\seealso{
\code{\link{TunedModel}}
}
