% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary}
\alias{summary}
\alias{summary.MLModelTune}
\alias{summary.Resamples}
\title{Model Performance Summary}
\usage{
\method{summary}{MLModelTune}(object, stats = c(Mean = mean, Median =
  median, SD = sd, Min = min, Max = max), na.rm = TRUE, ...)

\method{summary}{Resamples}(object, stats = c(Mean = mean, Median =
  median, SD = sd, Min = min, Max = max), na.rm = TRUE, ...)
}
\arguments{
\item{object}{object to summarize.}

\item{stats}{function or list of named functions to include in the
calculation of summary statistics.}

\item{na.rm}{logical indicating whether to exclude missing values.}

\item{...}{arguments passed to other methods.}
}
\value{
array with summmary statistics in the second dimension, metrics in
the first for single models, and models and metrics in the first and third,
respectively, for multiple models.
}
\description{
Summary statistics for resampled model performance metrics.
}
\examples{
## Factor response example

fo <- Species ~ .
control <- CVControl()

gbmperf1 <- resample(fo, iris, GBMModel(n.trees = 25), control)
gbmperf2 <- resample(fo, iris, GBMModel(n.trees = 50), control)
gbmperf3 <- resample(fo, iris, GBMModel(n.trees = 100), control)
summary(gbmperf3)

perf <- Resamples(GBM1 = gbmperf1, GBM2 = gbmperf2, GBM3 = gbmperf3)
summary(perf)

}
\seealso{
\code{\link{diff}}, \code{\link{resample}}, \code{\link{Resamples}},
\code{\link{tune}}
}
