% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_MT.R
\name{general_diagnosis.MT}
\alias{general_diagnosis.MT}
\title{General function to implement a diagnosis method for a family of 
  Mahalanobis-Taguchi (MT) methods}
\usage{
general_diagnosis.MT(unit_space, newdata, threshold,
  includes_transformed_newdata = FALSE)
}
\arguments{
\item{unit_space}{Object generated as a unit space.}

\item{newdata}{Matrix with n rows (samples) and p columns (variables). The 
data are used to calculate the desired distances from the 
unit space. All data should be continuous values and should 
not have missing values.}

\item{threshold}{Numeric specifying the threshold value to classify each 
sample into positive (\code{TRUE}) or negative 
(\code{FALSE}).}

\item{includes_transformed_newdata}{If \code{TRUE}, then the transformed data 
for \code{newdata} are included in a 
return object.}
}
\value{
A list containing the following components is returned.

\item{distance}{Vector with length n. Distances from the unit space to each 
                 sample.}
\item{le_threshold}{Vector with length n. Logical values indicating the 
                     distance of each sample is less than or equal to the 
                     threhold value (\code{TRUE}) or not (\code{FALSE}).}
\item{threshold}{Numeric value to classify the sample into positive or 
                  negative. }
\item{unit_space}{Object passed by \code{unit_space}.}
\item{n}{The number of samples for \code{newdata}.}
\item{q}{The number of independent variables after the data transformation. 
          According to the data transoformation function, q may be equal to p.}  
\item{x}{If \code{includes_transformed_newdata} is \code{TRUE}, then the 
          transformed data for \code{newdata} are included.}
}
\description{
\code{general_diagnosis.MT} is the general function that implements a 
  diagnosis method for a family of Mahalanobis-Taguchi (MT) methods. Each 
  diagnosis method of a family of MT methods can be implemented by setting 
  the parameters of this function appropriately.
}
\examples{
                          
# 40 data for versicolor in the iris dataset                            
iris_versicolor <- iris[61:100, -5] 

# The following settings are same as the MT method.                          
unit_space <- general_MT(unit_space_data = iris_versicolor, 
                         generates_transform_function = 
                                            generates_normalization_function,
                         calc_A = function(x) solve(cor(x)),  
                         includes_transformed_data = TRUE)

# 10 data for each kind (setosa, versicolor, virginica) in the iris dataset                         
iris_test <- iris[c(1:10, 51:60, 101:111), -5]
                         
diagnosis <- general_diagnosis.MT(unit_space = unit_space, 
                                  newdata = iris_test, 
                                  threshold = 4,
                                  includes_transformed_newdata = TRUE)
                              
(diagnosis$distance)
(diagnosis$le_threshold)                          

}
\seealso{
\code{\link{diagnosis.MT}}, \code{\link{diagnosis.MTA}}, and 
           \code{\link{diagnosis.RT}}
}

