% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSmix_functions_package.R
\name{summary.emMSmix}
\alias{summary.emMSmix}
\alias{print.summary.emMSmix}
\title{Summary of the fitted mixture of Mallows models with Spearman distance}
\usage{
\method{summary}{emMSmix}(object, digits = 3, ...)

\method{print}{summary.emMSmix}(x, ...)
}
\arguments{
\item{object}{An object of class \code{"emMSmix"} returned by \code{\link{fitMSmix}}.}

\item{digits}{Integer: decimal places for rounding the numerical summaries. Defaults to 3.}

\item{...}{Further arguments passed to or from other methods (not used).}

\item{x}{An object of class \code{"summary.emMSmix"} returned by \code{\link{summary.emMSmix}}.}
}
\value{
A list with the following named components:

\item{\code{modal_rankings}}{Integer matrix with the MLEs of the \eqn{G} component-specific consensus rankings in each row.}
\item{\code{modal_orderings}}{Character matrix with the MLEs of the \eqn{G} component-specific consensus orderings in each row.}
\item{\code{theta}}{Numeric vector of the MLEs of the \eqn{G} precisions.}
\item{\code{weights}}{Numeric vector of the MLEs of the \eqn{G} mixture weights.}
\item{\code{MAP_distr}}{Relative frequency distribution of the component memberships based on the MAP allocation.}
\item{\code{conv_perc}}{Percentage of convergence of the EM algorithm over the multiple starting points.}
\item{\code{BIC}}{BIC value (based on full or augmented rankings).}
\item{\code{BIC_part}}{BIC value (based on partial rankings).}
}
\description{
\code{summary} method for class \code{"emMSmix"}.

\code{print} method for class \code{"summary.emMSmix"}.
}
\examples{
## Example 1. Fit and summary of a 3-component mixture of Mallow models with Spearman distance
## for the Antifragility dataset.
set.seed(123)
mms_fit <- fitMSmix(rankings = ranks_antifragility, n_clust = 3, n_start = 10)
summary(mms_fit)


}
\seealso{
\code{\link{fitMSmix}}, \code{\link{plot.emMSmix}}
}
