% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindCommon.R
\name{FindCommon}
\alias{FindCommon}
\title{Find entities presented in both polarities}
\usage{
FindCommon(POSITIVE, NEGATIVE, ADDUCTS, Masstolerance, RTtolerance)
}
\arguments{
\item{POSITIVE}{A matrix with positive entities information (Compound Name, Mass, RT, and multiple columns with the area of the compound in samples).}

\item{NEGATIVE}{A matrix with positive entities information (Compound Name, Mass, RT, and multiple columns with the area of the compound in samples).}

\item{ADDUCTS}{A matrix with positive adducts, negative adducts and their difference in mass.}

\item{Masstolerance}{The tolerance in Da when considering the adducts that can be present in both matrices.}

\item{RTtolerance}{The tolerance of retention time when comparing both polarities. It should be in the same units as the RT in POSITIVE and NEGATIVE matrices.}
}
\description{
Takes matrices from positive and negative ionization mode and find entities in common.
}
\examples{
\dontrun{
CommonEntities<-FindCommon(POSITIVE,NEGATIVE,ADDUCTS,Masstolerance=0.02,RTtorelance=0.5)
}
}

