% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{MSARmdl}
\alias{MSARmdl}
\title{Markov-switching autoregressive model}
\usage{
MSARmdl(Y, p, k, control = list())
}
\arguments{
\item{Y}{(T x 1) vector with observational data.}

\item{p}{integer for the number of lags to use in estimation. Must be greater than or equal to \code{1}.}

\item{k}{integer for the number of regimes to use in estimation. Must be greater than or equal to \code{2}.}

\item{control}{List with model options including:
\itemize{
 \item getSE: Boolean. If \code{TRUE} standard errors are computed and returned. If \code{FALSE} standard errors are not computed. Default is \code{TRUE}.
 \item msmu: Boolean. If \code{TRUE} model is estimated with switch in mean. If \code{FALSE} model is estimated with constant mean. Default is \code{TRUE}.
 \item msvar: Boolean. If \code{TRUE} model is estimated with switch in variance. If \code{FALSE} model is estimated with constant variance. Default is \code{TRUE}.
 \item init_theta: vector of initial values. vector must contain \code{(1 x q)} vector \code{mu}, \code{vech(sigma)}, and \code{vec(P)} where sigma is a \code{(q x q)} covariance matrix.This is optional. Default is \code{NULL}, in which case \code{\link{initVals_MSARmdl}} is used to generate initial values.
 \item method: string determining which method to use. Options are \code{'EM'} for EM algorithm or \code{'MLE'} for Maximum Likelihood Estimation.
 \item maxit: integer determining the maximum number of EM iterations.
 \item thtol: double determining the convergence criterion for the absolute difference in parameter estimates \code{theta} between iterations. Default is \code{1e-6}.
 \item maxit_converge: integer determining the maximum number of initial values attempted until solution is finite. For example, if parameters in \code{theta} or \code{logLike} are \code{NaN} another set of initial values (up to \code{maxit_converge}) is attempted until finite values are returned. This does not occur frequently for most types of data but may be useful in some cases. Once finite values are obtained, this counts as one iteration towards \code{use_diff_init}. Default is \code{500}.
 \item use_diff_init: integer determining how many different initial values to try (that do not return \code{NaN}; see \code{maxit_converge}). Default is \code{1}.
 \item mle_stationary_constraint: Boolean determining if only stationary solutions are considered (if \code{TRUE}) or not (if \code{FALSE}). Default is \code{TRUE}.
 \item mle_variance_constraint: Double used to determine the lower bound for variance in each regime. Value should be between \code{0} and \code{1} as it is multiplied by single regime variance. Default is \code{0.01} (i.e., \code{1\%} of single regime variance.
 \item mle_theta_low: Vector with lower bounds on parameters (Used only if method = "MLE"). Default is \code{NULL}.
 \item mle_theta_upp: Vector with upper bounds on parameters (Used only if method = "MLE"). Default is \code{NULL}.
}}
}
\value{
List of class \code{MSARmdl} (\code{S3} object) with model attributes including:
\itemize{
  \item y: a \code{(T x 1)} matrix of observations.
  \item X: a \code{(T-p x p + const)} matrix of lagged observations with a leading column of \code{1}s.
  \item x: a \code{(T-p x p)} matrix of lagged observations.
  \item fitted: a \code{(T x 1)} matrix of fitted values.
  \item resid: a \code{(T x 1)} matrix of residuals.
  \item inter: a \code{(k x 1)} vector of estimated intercepts of each process.
  \item mu: a \code{(k x 1)} vector of estimated means of each process.
  \item phi: estimates of autoregressive coefficients.
  \item stdev: a \code{(k x 1)} vector of estimated standard deviation of each process.
  \item sigma: a \code{(k x 1)} estimated covariance matrix.
  \item theta: vector containing: \code{mu} and \code{vech(sigma)}.
  \item theta_mu_ind: vector indicating location of mean with \code{1} and \code{0} otherwise.
  \item theta_sig_ind: vector indicating location of variances with \code{1} and \code{0} otherwise.
  \item theta_var_ind: vector indicating location of variances with \code{1} and \code{0} otherwise. This is the same as \code{theta_sig_ind} in \code{MSARmdl}.
  \item theta_P_ind: vector indicating location of transition matrix elements with \code{1} and \code{0} otherwise.
  \item stationary: Boolean indicating if process is stationary if \code{TRUE} or non-stationary if \code{FALSE}.
  \item n: number of observations (same as \code{T}).
  \item p: number of autoregressive lags.
  \item q: number of series. This is always \code{1} in \code{MSARmdl}.
  \item k: number of regimes in estimated model.
  \item P: a \code{(k x k)} transition matrix.
  \item pinf: a \code{(k x 1)} vector with limiting probabilities of each regime.
  \item St: a \code{(T x k)} vector with smoothed probabilities of each regime at each time \code{t}.
  \item deltath: double with maximum absolute difference in vector \code{theta} between last iteration.
  \item iterations: number of EM iterations performed to achieve convergence (if less than \code{maxit}).
  \item theta_0: vector of initial values used.
  \item init_used: number of different initial values used to get a finite solution. See description of input \code{maxit_converge}.
  \item msmu: Boolean. If \code{TRUE} model was estimated with switch in mean. If \code{FALSE} model was estimated with constant mean.
  \item msvar: Boolean. If \code{TRUE} model was estimated with switch in variance. If \code{FALSE} model was estimated with constant variance.
  \item control: List with model options used.
  \item logLike: log-likelihood.
  \item AIC: Akaike information criterion.
  \item BIC: Bayesian (Schwarz) information criterion.
  \item Hess: Hessian matrix. Approximated using \code{\link[numDeriv]{hessian}} and only returned if \code{getSE=TRUE}.
  \item info_mat: Information matrix. Computed as the inverse of \code{-Hess}. If matrix is not PD then nearest PD matrix is obtained using \code{\link[pracma]{nearest_spd}}. Only returned if \code{getSE=TRUE}.
  \item nearPD_used: Boolean determining whether \code{nearPD} function was used on \code{info_mat} if \code{TRUE} or not if \code{FALSE}. Only returned if \code{getSE=TRUE}.
  \item theta_se: standard errors of parameters in \code{theta}.  Only returned if \code{getSE=TRUE}.
  \item trace: List with Lists of estimation output for each initial value used due to \code{use_diff_init > 1}.
}
}
\description{
This function estimates a Markov-switching autoregressive model
}
\examples{
# --------------------------- Use simulated process ----------------------------
set.seed(1234)
# Define DGP of MS AR process
mdl_ms2 <- list(n     = 200, 
                mu    = c(5,10),
                sigma = c(1,4),
                phi   = c(0.5),
                k     = 2,
                P     = rbind(c(0.90, 0.10),
                              c(0.10, 0.90)))

# Simulate process using simuMSAR() function
y_ms_simu <- simuMSAR(mdl_ms2)

# Set options for model estimation
control <- list(msmu   = TRUE, 
                msvar  = TRUE, 
                method = "EM",
                use_diff_init = 1)

# Estimate model
\donttest{
  ms_mdl <- MSARmdl(y_ms_simu$y, p = 1, k = 2, control)
  summary(ms_mdl)
}



}
\references{
Dempster, A. P., N. M. Laird, and D. B. Rubin. 1977. “Maximum Likelihood from Incomplete Data via the EM Algorithm.” \emph{Journal of the Royal Statistical Society}. Series B 39 (1): 1–38..

Hamilton, James D. 1990. “Analysis of time series subject to changes in regime.” \emph{Journal of econometrics}, 45 (1-2): 39–70.
}
\seealso{
\code{\link{ARmdl}}
}
