% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Volatility.R
\name{Volatility}
\alias{Volatility}
\alias{Volatility.MSGARCH_SPEC}
\alias{Volatility.MSGARCH_ML_FIT}
\alias{Volatility.MSGARCH_MCMC_FIT}
\title{Volatility filtering.}
\usage{
Volatility(object, ...)

\method{Volatility}{MSGARCH_SPEC}(object, par, data, ...)

\method{Volatility}{MSGARCH_ML_FIT}(object, newdata = NULL, ...)

\method{Volatility}{MSGARCH_MCMC_FIT}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC}
created with \code{\link{CreateSpec}} or fit object of type \code{MSGARCH_ML_FIT}
created with \code{\link{FitML}} or \code{MSGARCH_MCMC_FIT} created with \code{\link{FitMCMC}}.}

\item{...}{Not used. Other arguments to \code{Volatility}.}

\item{par}{Vector (of size d) or matrix (of size \code{nmcmc} x d) of parameter
estimates where d must have the same length as the default parameters of the specification.}

\item{data}{Vector (of size T) of observations.}

\item{newdata}{Vector (of size T*) of new observations. (Default \code{newdata = NULL})}
}
\value{
Condititional volatility (vector of size T + T*) of class \code{MSGARCH_CONDVOL}.\cr
The \code{MSGARCH_CONDVOL} class contains the \code{plot} method.
}
\description{
Method returning the conditional volatility of the process.
}
\details{
If a matrix of MCMC posterior draws is given, the
Bayesian predictive conditional volatility is calculated.
}
\examples{
# load data
data("SMI", package = "MSGARCH")

# create model specification
# MS(2)-GARCH(1,1)-Normal (default)
spec <- CreateSpec()

# fit the model on the data by ML
fit <- FitML(spec = spec, data = SMI)

# compute the In-sample conditional volatility from the fitted model
cond.vol <- Volatility(object = fit)
plot(cond.vol)
}
