% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B_Low_functions.R
\name{Blow_opt}
\alias{Blow_opt}
\title{Blow internal parallel optimization function}
\usage{
Blow_opt(
  lnq,
  N,
  Asize_c,
  SSBMSYc,
  SSBpRc,
  MPA,
  SSB0c,
  nareas,
  retAc,
  MGThorizonc,
  Fc,
  Perrc,
  Mc,
  hc,
  Mac,
  Wac,
  Fecac,
  R0c,
  Vc,
  nyears,
  maxage,
  movc,
  Spat_targc,
  SRrelc,
  aRc,
  bRc,
  Bfrac,
  maxF,
  mode = 1,
  plusgroup = 0,
  SRRfun,
  SRRpars
)
}
\arguments{
\item{lnq}{number: estimate of log catchability}

\item{N}{matrix maxage by nareas with initial numbers at age}

\item{Asize_c}{vector length nareas with size of each area}

\item{SSBMSYc}{number: spawning biomass at MSY}

\item{SSBpRc}{vector length nareas with SSBpR by area}

\item{MPA}{matrix of spatial closures}

\item{SSB0c}{SSB0}

\item{nareas}{numeric: number of areas}

\item{retAc}{matrix maxage by nyears+proyears of retention by age and year}

\item{MGThorizonc}{number: MGT x HZN}

\item{Fc}{vector nyears long of fishing mortality rate}

\item{Perrc}{vector nyears+maxage-1 long of recruitment deviations}

\item{Mc}{matrix maxage by nyears+proyears of natural mortality rate}

\item{hc}{number: steepness values}

\item{Mac}{matrix nages by nyears+proyears of maturity at age}

\item{Wac}{vector nages long  of weight at age}

\item{Fecac}{vector nages long  of mature weight at age}

\item{R0c}{number: unfished recruitment}

\item{Vc}{matrix of vulnerability maxage x nyears}

\item{nyears}{integer: number of historical years}

\item{maxage}{integer: maximum age}

\item{movc}{matrix of movement 2 x 2}

\item{Spat_targc}{number: spatial targeting parameters}

\item{SRrelc}{integer representing recruitment dynamics type 1: Bev Holt 2: Ricker}

\item{aRc}{number: recruitment parameter}

\item{bRc}{number: recruitment parameter}

\item{Bfrac}{fraction of SSBMSY that is the target}

\item{maxF}{maximum apical fishing mortality}

\item{mode}{1: find Blow 2:report blow  3:plot results}

\item{plusgroup}{Integer. Default = 0 = no plus-group. Use 1 to include a plus-group}
}
\description{
Find the current biomass at which it would take HZN mean generation times
to reach Bfrac x SSBMSY biomass level given zero catches
}
\author{
T. Carruthers with modifications by A. Hordyk
}
\keyword{internal}
