% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_DD.R
\name{DD_TMB}
\alias{DD_TMB}
\alias{DD_SS}
\title{Delay - Difference Stock Assessment in TMB}
\usage{
DD_TMB(x = 1, Data, SR = c("BH", "Ricker"), rescale = "mean1",
  start = NULL, fix_h = TRUE, fix_U_equilibrium = TRUE,
  silent = TRUE, opt_hess = FALSE, n_restart = ifelse(opt_hess, 0,
  1), control = list(iter.max = 5000, eval.max = 10000), ...)

DD_SS(x = 1, Data, SR = c("BH", "Ricker"), rescale = "mean1",
  start = NULL, fix_h = TRUE, fix_U_equilibrium = TRUE,
  fix_omega = FALSE, fix_tau = TRUE, integrate = FALSE,
  silent = TRUE, opt_hess = FALSE, n_restart = ifelse(opt_hess, 0,
  1), control = list(iter.max = 5000, eval.max = 10000),
  inner.control = list(), ...)
}
\arguments{
\item{x}{An index for the objects in \code{Data} when running in closed loop simulation.
Otherwise, equals to 1 when running an assessment.}

\item{Data}{An object of class \linkS4class{Data}.}

\item{SR}{Stock-recruit function (either \code{"BH"} for Beverton-Holt or \code{"Ricker"}).}

\item{rescale}{A multiplicative factor that rescales the catch in the assessment model, which
can improve convergence. By default, \code{"mean1"} scales the catch so that time series mean is 1, otherwise a numeric.
Output is re-converted back to original units.}

\item{start}{Optional list of starting values. Entries can be expressions that are evaluated in the function. See details.}

\item{fix_h}{Logical, whether to fix steepness to value in \code{Data@steep} in the assessment model.}

\item{fix_U_equilibrium}{Logical, whether the equilibrium harvest rate prior to the first year of the model is
estimated. If TRUE, U_equilibruim is fixed to value provided in start (if provided), otherwise, equal to zero
(assumes virgin conditions).}

\item{silent}{Logical, passed to \code{\link[TMB]{MakeADFun}}, whether TMB
will print trace information during optimization. Used for dignostics for model convergence.}

\item{opt_hess}{Logical, whether the hessian function will be passed to \code{\link[stats]{nlminb}} during optimization
(this generally reduces the number of iterations to convergence, but is memory and time intensive and does not guarantee an increase
in convergence rate). Ignored if \code{integrate = TRUE}.}

\item{n_restart}{The number of restarts (calls to \code{\link[stats]{nlminb}}) in the optimization procedure, so long as the model
hasn't converged. The optimization continues from the parameters from the previous (re)start.}

\item{control}{A named list of parameters regarding optimization to be passed to
\code{\link[stats]{nlminb}}.}

\item{...}{Additional arguments (not currently used).}

\item{fix_omega}{Logical, whether the standard deviation of the catch is fixed. If \code{TRUE},
omega is fixed to value provided in \code{start} (if provided), otherwise, value based on \code{Data@CV_Cat}.}

\item{fix_tau}{Logical, the standard deviation of the recruitment deviations is fixed. If \code{TRUE},
tau is fixed to value provided in \code{start} (if provided), otherwise, equal to 1.}

\item{integrate}{Logical, whether the likelihood of the model integrates over the likelihood
of the recruitment deviations (thus, treating it as a random effects/state-space variable).
Otherwise, recruitment deviations are penalized parameters.}

\item{inner.control}{A named list of arguments for optimization of the random effects, which
is passed on to \code{\link[TMB]{newton}} via \code{\link[TMB]{MakeADFun}}.}
}
\value{
An object of \code{\linkS4class{Assessment}} containing objects and output
from TMB.
}
\description{
A simple delay-difference assessment model using a
time-series of catches and a relative abundance index and coded in TMB. The model
is conditioned on effort and estimates predicted catch. In the state-space version,
recruitment deviations from the stock-recruit relationship are estimated.
}
\details{
To provide starting values for \code{DD_TMB}, a named list can be provided for \code{R0} (virgin recruitment),
\code{h} (steepness), and \code{q} (catchability coefficient) via the \code{start} argument (see example).

For \code{DD_SS}, additional start values can be provided for and \code{omega} and \code{tau}, the standard
deviation of the catch and recruitment variability, respectively.
}
\section{Functions}{
\itemize{
\item \code{DD_TMB}: Observation-error only model

\item \code{DD_SS}: State-Space version of Delay-Difference model
}}

\note{
Similar to many other assessment
models, the model depends on assumptions such as stationary productivity and
proportionality between the abundance index and real abundance.
Unsurprisingly the extent to which these assumptions are
violated tends to be the biggest driver of performance for this method.
}
\section{Required Data}{

\itemize{
\item \code{DD_TMB}: Cat, Ind, Mort, L50, vbK, vbLinf, vbt0, wla, wlb, MaxAge
\item \code{DD_SS}: Cat, Ind, Mort, L50, vbK, vbLinf, vbt0, wla, wlb, MaxAge
}
}

\section{Optional Data}{

\itemize{
\item \code{DD_TMB}: steep
\item \code{DD_SS}: steep, CV_Cat
}
}

\examples{
\donttest{
#### Observation-error delay difference model
res <- DD_TMB(Data = DLMtool::Red_snapper)

# Provide starting values
start <- list(R0 = 1, h = 0.95)
res <- DD_TMB(Data = DLMtool::Red_snapper, start = start)

summary(res@SD) # Parameter estimates

### State-space version
### Set recruitment variability SD = 0.3 (since fix_tau = TRUE)
res <- DD_SS(Data = Red_snapper, start = list(tau = 0.3))
}
}
\references{
Carruthers, T, Walters, C.J,, and McAllister, M.K. 2012. Evaluating methods that classify
fisheries stock status using only fisheries catch data. Fisheries Research 119-120:66-79.

Hilborn, R., and Walters, C., 1992. Quantitative Fisheries Stock Assessment: Choice,
Dynamics and Uncertainty. Chapman and Hall, New York.
}
\seealso{
\link{plot.Assessment} \link{summary.Assessment} \link{retrospective} \link{profile} \link{make_MP}
}
\author{
T. Carruthers & Z. Siders. Zach Siders coded the TMB function.
}
