% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCRs.R
\name{HCR_MSY}
\alias{HCR_MSY}
\title{A harvest control rule to fish at maximum sustainable yield.}
\usage{
HCR_MSY(Assessment, reps = 1, ...)
}
\arguments{
\item{Assessment}{An object of class \linkS4class{Assessment} with estimates of
FMSY or UMSY and vulnerable biomass in terminal year.}

\item{reps}{The number of stochastic samples of the TAC recommendation.}

\item{...}{Miscellaneous arguments (not currently used).}
}
\value{
An object of class \linkS4class{Rec} with the TAC recommendation.
}
\description{
A simple control rule that specifies the total allowable catch (TAC) to be the
product of current vulnerable biomass (VB_final) and FMSY (or UMSY).
}
\examples{
# create an MP to run in closed-loop MSE
DD_MSY <- make_MP(DD_TMB, HCR_MSY)
class(DD_MSY)
\dontrun{
myOM <- DLMtool::runMSE(DLMtool::testOM, MPs = c("FMSYref", "DD_MSY"))
}
}
\references{
Punt, A. E, Dorn, M. W., and Haltuch, M. A. 2008. Evaluation of threshold management strategies
for groundfish off the U.S. West Coast. Fisheries Research 94:251-266.
}
\seealso{
\link{make_MP}
}
\author{
Q. Huynh
}
