% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.r
\name{compare}
\alias{compare}
\title{Compare MSCMT estimation results}
\usage{
compare(..., auto.name.prefix = "")
}
\arguments{
\item{...}{Objects of class \code{"mscmt"} or (a) list(s) containing objects
of class \code{"mscmt"}.}

\item{auto.name.prefix}{A character string (default: "") internally used to 
facilitate automatic naming in nested lists of unnamed estimation results.}
}
\value{
An object of class \code{"mscmt"}, which itself contains the 
individual estimation results as well as a component \code{"comparison"} 
with aggregated information.
}
\description{
\code{compare} collects estimation results from \code{\link{mscmt}} for
comparison purposes.
}
\details{
\code{compare} collects (potentially many) estimation results from 
\code{\link{mscmt}} in a special object of class \code{"mscmt"}, which 
includes a component \code{"comparison"} where the different estimation 
results are aggregated.
This aggregated information is used by the \code{\link{ggplot.mscmt}} and 
\code{\link{print.mscmt}} methods to present summaries of the different
results.
}
