% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfuns.R
\name{plotprofile}
\alias{plotprofile}
\title{plotprofile simplifies plotting single likelihood profiles}
\usage{
plotprofile(
  prof,
  var,
  digit = c(3, 3, 3),
  xlabel = var,
  ylabel = "-ve Log-Likelihood",
  like = "-veLL",
  defpar = TRUE,
  ...
)
}
\arguments{
\item{prof}{the results from the likelihood profile calculations. 
This matrix should include, as a minimum, the fixed variable 
of interest and the matching -ve log-likelihood in named 
columns.}

\item{var}{the name of the variable of interest to identify the 
column in prof in which to find the vector of fixed values 
given.}

\item{digit}{this is a vector of three that determine by how much 
the round function limits the values printed of the 95% and 
mean at the top of the plot.}

\item{xlabel}{the x-axis label, defaults to the name of the var}

\item{ylabel}{the y-axis label, defaults to -ve Log-Likelihood}

\item{like}{identifies the name of the column containing the -ve 
log-likelihood}

\item{defpar}{logical, should the par values be assumed or defined, 
defaults to TRUE, so only one plot will be produced and any old
par values will be restored afterwards. If part of a multiple 
plot define the formatting before calling and set this
to FALSE. This will lead to the oldpar being returned invisibly
so that eventually the par settings can be reset.}

\item{...}{used for any other graphic parameters used.}
}
\value{
nothing but this does generate a plot.
}
\description{
plotprofile simplifies plotting out the likelihood 
    profiles of single parameters or variables. It is necessary to 
    pass the function the output from the profile calculations, 
    identifying the variable name against which to plot the 
    likelihood. Identifying the name of the -ve log-likelihood 
    column. Facilities are provided for defining the x and y axis 
    labels. We need to use the function which.closest because we
    use a sequence of parameter values so an exact match would be
    highly unlikely.
}
\examples{
 data(abdat)    #usually use  ~100 steps in rval, perhaps use
 rval <- seq(0.325,0.45,0.02)   # seq(0.325,0.45,0.001)
 ntrial <- length(rval)
 columns <- c("r","K","Binit","sigma","-veLL")
 result <- matrix(0,nrow=ntrial,ncol=length(columns),
                  dimnames=list(rval,columns))
 bestest <- c(r= 0.32,K=11000,Binit=4000,sigma=0.05) 
 for (i in 1:ntrial) {  #i <- 1
   param <- log(c(rval[i],bestest[2:4])) 
   parinit <- param    
   bestmodP <- nlm(f=negLLP,p=param,funk=simpspm,initpar=parinit,
                  indat=abdat,logobs=log(abdat$cpue),notfixed=c(2:4),
                  typsize=magnitude(param),iterlim=1000)
   bestest <- exp(bestmodP$estimate)
   result[i,] <- c(bestest,bestmodP$minimum)
 }
 plotprofile(result,var="r",defpar=TRUE,lwd=2)
}
