% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{MLmulti}
\alias{MLmulti}
\title{Multispecies mean length mortality estimator}
\usage{
MLmulti(MLZ.list, ncp, model = c("SSM", "MSM1", "MSM2", "MSM3"),
  start = NULL, grid.search = TRUE, parallel = ifelse(ncp > 2, TRUE,
  FALSE), min.time = 3, figure = TRUE)
}
\arguments{
\item{MLZ.list}{A list containing objects of class \code{\linkS4class{MLZ_data}}.}

\item{ncp}{The number of change points in total mortality in the time series. \code{ncp + 1} total
mortality rates will be estimated.}

\item{model}{The multispecies model to be used.}

\item{start}{An optional list of starting values. See details.}

\item{grid.search}{If \code{TRUE}, a grid search will be performed using the \code{\link{profile_MLmulti}}
function to find the best starting values for the change points (the years when mortality changes).
Ignored if \code{start} is provided.}

\item{parallel}{Whether grid search is performed in parallel. Ignored if \code{grid.search = FALSE}.}

\item{min.time}{The minimum number of years between each change point for the grid search, passed
to \code{\link{profile_MLmulti}}. Not used if \code{grid.search = FALSE}.}

\item{figure}{If \code{TRUE}, a call to \code{plot} of observed and predicted mean lengths will be produced.}
}
\value{
An object of class \code{\linkS4class{MLZ_model}}.
}
\description{
Estimator of instantaneous total mortality (Z) from a time series of mean length data for a suite of
stocks that are fished together.
}
\details{
For a model with \code{I} change points and \code{N} species, the starting values in
\code{start} is a list with the following entries:

Single Species Model (SSM):
\tabular{ll}{
\code{Z} \tab a matrix with \code{nrow = I+1} and \code{ncol = N}.\cr
\code{yearZ} \tab a matrix with \code{nrow = I} and \code{ncol = N}.\cr
}

Multispecies Model 1 (MSM1):
\tabular{ll}{
\code{Z} \tab a matrix with \code{nrow = I+1} and \code{ncol = N}.\cr
\code{yearZ} \tab a vector with \code{length = I}.\cr
}

Multispecies Model 2 (MSM2):
\tabular{ll}{
\code{Z1} \tab a vector with \code{length = N}.\cr
\code{yearZ} \tab a vector with \code{length = I}.\cr
\code{delta} \tab a vector with \code{length = I}.\cr
\code{epsilon} \tab a vector with \code{length = N-1}.\cr
}

Multispecies Model 3 (MSM3):
\tabular{ll}{
\code{Z1} \tab a vector with \code{length = N}.\cr
\code{yearZ} \tab a vector with \code{length = I}.\cr
\code{delta} \tab a vector with \code{length = I}.\cr
}

If \code{ncp = 0} change points is specified, then the method simplifies to the Single Species Model.
The \code{start} list should contain a single entry:
\tabular{ll}{
\code{Z} \tab a vector with \code{length = N}.\cr
}

\code{start} can be \code{NULL}, in which case, the supplied starting values depend on
the value of \code{grid.search}. If \code{grid.search = TRUE}, starting values will use the
values for \code{yearZ} which minimize the negative log-likelihood from the grid search.
Otherwise, the starting values for \code{yearZ} evenly divide the time series.
}
\examples{
data(PRSnapper)
MLmulti(PRSnapper, ncp = 0, start = list(Z = matrix(0.5, nrow = 1, ncol = 3)))
MLmulti(PRSnapper, ncp = 1, model = "SSM")

MSM1.start.Z <- matrix(0.5, nrow = 2, ncol = 3)
MSM1.start.yearZ <- 1990
start.list <- list(Z = MSM1.start.Z, yearZ = MSM1.start.yearZ)
MLmulti(PRSnapper, ncp = 1, model = "MSM1", start = start.list, grid.search = FALSE)

MLmulti(PRSnapper, ncp = 1, model = "MSM2")

st.Z1 <- rep(0.5, 3)
st.yearZ <- 1990
st.delta <- 1
start.list <- list(Z1 = st.Z1, yearZ = st.yearZ, delta = st.delta)
MLmulti(PRSnapper, ncp = 1, model = "MSM3", start = start.list)
}
\references{
Huynh, Q.C, Gedamke, T., Hoenig, J.M, and Porch C. 2017. Multispecies Extensions
to a Nonequilibrium Length-Based Mortality Estimator. Marine and Coastal Fisheries 9:68-78.
}
\seealso{
\code{\link{profile_MLmulti}}
}
