% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/byrgu.R
\name{byrgu}
\alias{byrgu}
\title{Bayesian analysis of repeated measurement data using
linear regression with an unstructured covariance matrix}
\usage{
byrgu(m, n, n.chains, data)
}
\arguments{
\item{m}{starting column number}

\item{n}{ending column number}

\item{n.chains}{number of MCMC chains}

\item{data}{dataset whose first row is the respective time points at which observations are taken}
}
\value{
posterior distribution results of the parameters
}
\description{
Bayesian analysis is performed using MCMC and uses a
linear regression with an unstructured covariance matrix and the prior distributions are
uninformative normal distributions for the regression coefficients and an uninformative Wishart for
the 3 by 3 precision matrix of the outcome variable measured at 3 timepoints.
}
\details{
The mean reponse model is \deqn{E(Y_{ij})=\beta_0+\beta_1t_j}  with unstructured
covariance \eqn{\Sigma} where i refers to ith individual and j is the timepoint.
}
\examples{
 ##
 data(repeatdata)
 byrgu(m=1,n=3,n.chains=1,data=repeatdata)
 ##
}
\author{
Atanu Bhattacharjee,Bhrigu Kumar Rajbongshi and Gajendra K Vishwakarma
}
