% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bprp.R
\name{bprp}
\alias{bprp}
\title{Bayesian analysis of generalised nonlinear mixed model with one random effect
using MCMC}
\usage{
bprp(m, n, n.chains, data)
}
\arguments{
\item{m}{starting column number}

\item{n}{ending column number}

\item{n.chains}{number of MCMC chains}

\item{data}{dataset with entries 0,1. first row represents proportion;size of dataset 
should be 11 by 6. Inside the function we are taking first 6 column of the propdata in this package for the given example}
}
\value{
posterior distribution result of parameters.
}
\description{
provides Bayesian analysis of generalized nonlinear mixed model where response follows Poisson distribution using
MCMC
}
\details{
The response variable \eqn{Y_{ij}} follows poisson distribution
with conditional mean and variance \eqn{E(Y_{ij}|b_i)=Var(Y_{ij}|b_i)}
\eqn{b_i} are independent \eqn{N(0,\sigma^2)} and link function is 
\deqn{logit(\theta_{ij})=\beta_1+\beta_2(1-x_{ij}^{\beta_3+b_i})}
where \eqn{\theta_{ij}=P(Y_{ij}=1/b_i)},
\eqn{x_{ij}} is the proportion
}
\examples{
##
data(propdata)
bprp(m=1,n=4,n.chains=1,data=propdata)
##
}
\references{
Broemeling, Lyle D. Bayesian methods for repeated measures. CRC Press, 2015.
}
\author{
Atanu Bhattacharjee,Bhrigu Kumar Rajbongshi and Gajendra K Vishwakarma
}
