% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmodel.R
\name{rdata.mhmm}
\alias{rdata.mhmm}
\title{Generator}
\usage{
rdata.mhmm(n = 50, nbT = 40, A = list(matrix(c(0.7, 0.3, 0.1, 0.2,
  0.6, 0.1, 0.1, 0.1, 0.8), 3, 3), matrix(1/3, 3, 3)),
  delta = rep(1/length(A), length(A)), a = c(1, 2, 3) * 10, b = c(1,
  1, 1), eps = c(0.5, 0.1, 0.2) * 0)
}
\arguments{
\item{n}{numeric, number of subjects.}

\item{nbT}{numeric, length of the sequence.}

\item{A}{list, matrices of the transition probabilities per class}

\item{delta}{numeric, proportions of the classes.}

\item{a}{numeric, shapes of the gamma distributions.}

\item{b}{numeric, rates of the gamma distributions.}

\item{eps}{numeric, proportions of the zero-inflated in the emission laws.}
}
\value{
Returns a list of sequences.
}
\description{
This function generates sequence from a MHMM model
}
\examples{
ech <- rdata.mhmm(25, 10)
res <- mhmm(ech$y, K = 2, M = 4, nbcores = 1, nbinit = 5, iterSmall = 2)
}
