% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGLMgen.R, R/pdfln.R
\name{rmn}
\alias{rmn}
\alias{mn}
\alias{dmn}
\title{The Multinomial Distribution}
\usage{
rmn(n, size, alpha)

dmn(Y, prob)
}
\arguments{
\item{n}{number of random vectors to generate.}

\item{size}{a scalar or a vector.}

\item{alpha}{a vector or a matrix.}

\item{Y}{the multivariate count matrix with dimension \eqn{n \times d}{n x d}, where 
\eqn{n = 1,2,\ldots} is number of observations and \eqn{d=2,\ldots} is number of categories.}

\item{prob}{the probability parameter of the multinomial distribution.  \code{prob}
can be either a vector of length \eqn{d} or a matrix with matching 
size of \code{Y}.  If \code{prob} is a vector, it will be replicated \eqn{n} 
times to match the dimension of \code{Y}. If the sum(s) of \code{prob} is not 1, it will be automatically scaled to have sum 1.}
}
\value{
The function \code{dmn} returns the value of \eqn{\log(P(y|p))}{logP(y|p)}. 
When \code{Y} is a matrix of \eqn{n} rows, the function returns a 
vector of length \eqn{n}. 

The function \code{rmn} returns multinomially distributed random number vectors
}
\description{
\code{rmn} generates random number vectors given \code{alpha}. 
The function \code{rmn(n, size, alpha)} calls \code{rmultinom(n, size, prob)} after converting \code{alpha} to probability. 
\code{dmn} computes the log of multinomial probability mass function.
}
\details{
A multinomial distribution models the counts of \eqn{d} possible outcomes.
The counts of categories are negatively correlated. 
\eqn{y=(y_1, \ldots, y_d)} is a \eqn{d} category count vector. 
Given the parameter vector \eqn{p = (p_1, \ldots, p_d)}, \eqn{0 < p_j < 1}, 
\eqn{\sum_{j=1}^d p_j = 1}{sum_{j=1}^d p_j = 1}, the function calculates the log of the multinomial pmf
\deqn{
  P(y|p) = C_{y_1, \ldots, y_d}^{m} \prod_{j=1}^{d} p_j^{y_j},
}{
  P(y|p) = C_{y_1, \ldots, y_d}^{m} prod_{j=1}^{d} p_j^{y_j},
}
where \eqn{m=\sum_{j=1}^d y_j}{m = sum_{j=1}^d y_j}. Here, \eqn{C_k^n}, often read as "\eqn{n} choose \eqn{k}", 
refers the number of \eqn{k} combinations from a set of \eqn{n} elements.

The parameter \eqn{p} can be one vector, like the result from the distribution
fitting function; or, \eqn{p} can be a matrix with \eqn{n} rows, like the estimate
from the regression function, 
\deqn{p_j = \frac{exp(X \beta_j)}{1 + sum_{j'=1}^{d-1} exp(X\beta_{j'})},}{p_j = (exp(X \beta_j)) / (1 + sum_{j'=1}^{d-1} exp(X\beta_{j'})),} where \eqn{j=1,\ldots,d-1}
and \eqn{p_d = \frac{1}{1 + \sum_{j'=1}^{d-1} exp(X\beta_{j'})}}{p_d = 1/(1 + sum_{j'=1}^{d-1} exp(X\beta_{j'}))}.
The \eqn{d}-th column of the coefficient matrix \eqn{\beta} is set to \eqn{0} to avoid the identifiability issue.
}
\examples{
m <- 20
prob <- c(0.1, 0.2)
dm.Y <- rdirmn(n=10, m, prob)	
pdfln <- dmn(dm.Y, prob)
}
\author{
Yiwen Zhang and Hua Zhou
}
\keyword{distribution}
\keyword{models}
