% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary-batch.R
\name{batch_migration}
\alias{batch_migration}
\title{Sample Batch Migration Events}
\usage{
batch_migration(
  SPN_P,
  tmax,
  ELPrates = NULL,
  ELPmove = NULL,
  ELPprob = NULL,
  Frates = NULL,
  Fmove = NULL,
  Fprob = NULL,
  Mrates = NULL,
  Mmove = NULL,
  Mprob = NULL
)
}
\arguments{
\item{SPN_P}{places of the SPN}

\item{tmax}{maximum time of the simulation}

\item{ELPrates}{rate at which aquatic stage batch migration occurs for each node (nodes without mosquitoes should be set to \code{NaN} or \code{NA})}

\item{ELPmove}{movement matrix for destinations of aquatic stage batch migration events (diagonal will be set to zero and off-diagonal elements normalized)}

\item{ELPprob}{probability for each individual to be chosen for aquatic stage batch migration events (must be same length as \code{ELPrates})}

\item{Frates}{rate at which adult female batch migration occurs for each node (nodes without mosquitoes should be set to \code{NaN} or \code{NA})}

\item{Fmove}{movement matrix for destinations of adult female batch migration events (diagonal will be set to zero and off-diagonal elements normalized)}

\item{Fprob}{probability for each individual to be chosen for adult female batch migration events (must be same length as \code{Frates})}

\item{Mrates}{rate at which adult male batch migration occurs for each node (nodes without mosquitoes should be set to \code{NaN} or \code{NA})}

\item{Mmove}{movement matrix for destinations of adult male batch migration events (diagonal will be set to zero and off-diagonal elements normalized)}

\item{Mprob}{probability for each individual to be chosen for adult male batch migration events (must be same length as \code{Mrates})}
}
\description{
Sample batch migration events for simulation given rates of occurance and probability of destination for each patch.
Batch migration can be simulated for the aquatic life stages (eggs, larvae, pupae), adult females, and/or adult males.
To simulate batch migration, each life stage needs all 3 of its arguments specified. If any arguments are left
unspecified (\code{NULL}), batch migration for that life stage will not be sampled.
The output of this function should be passed to \code{\link[MGDrivE2]{sim_trajectory_R}} or \code{\link[MGDrivE2]{sim_trajectory_CSV}}
as the argument \code{batch}.
Calls the internal function \code{\link[MGDrivE2]{batch_migration_stage}}.
}
