\name{formatting.covars}
\alias{formatting.covars}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Reformat matrix of covariates.
}
\description{
This function reformats the matrix of input covariates into the required format for the link probabilities and for the mixing proportions.
}
\usage{
formatting.covars(covars, link.vars, mix.vars, n)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
   \item{covars}{
The n x p data frame of node specific covariates passed in to the overall \code{\link{MEclustnet}} function. The first column should be a column of 1's and categorical variables should be factors.
}
  \item{link.vars}{
A vector detailing the column numbers of the matrix covars that should be included in the link probabilities model.
}
  \item{mix.vars}{
A vector detailing the column numbers of the matrix covars that should be included in the mixing proportions probabilities model.
}
  \item{n}{
The number of nodes in the network.
}
}
\details{
For the link regression model, the difference in the link.vars covariates, for all pairs of nodes is calculated.

For the mixing proportions model, the required representation of the mix.vars required is formed, where for categorical/factor variables a dummy value representation is used.
}
\value{
A list with
\item{x.link }{A matrix with \eqn{n^2} rows and length(link.vars) columns, detailing the differences in covariates for all pairs of nodes.}
\item{x.mix }{A matrix with n rows and number of columns equal to the number of variables detailed in mix.vars, where dummy variable representations will be used for categorical.factor covariates.}
}
\references{
Isobel Claire Gormley and Thomas Brendan Murphy. (2010) A Mixture of Experts Latent Position Cluster Model for Social Network Data. Statistical Methodology, 7 (3), pp.385-405.
}

\author{
Isobel Claire Gormley <claire.gormley@ucd.ie>
}

\seealso{
\code{\link{MEclustnet}}
}
\examples{
data(us.twitter.covariates)
link.vars = c(1)
mix.vars = c(1,5,7,8)
res = formatting.covars(us.twitter.covariates, link.vars, mix.vars, nrow(us.twitter.covariates))
dim(res$x.link)
dim(res$x.mix)
}

\keyword{ methods }
\keyword{ cluster }
\keyword{ multivariate }
