% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepost.R
\name{prepost.test}
\alias{prepost.test}
\title{Pretest-posttest RCT for quantitative observations with possible missing values}
\usage{
prepost.test(baseline, post, treatment, conf.level = 0.95,
  delta = "estimate")
}
\arguments{
\item{baseline}{A vector of quantitative baseline measurements}

\item{post}{A vector of quantitative post-test measurements with same length as baseline. May contain missing values}

\item{treatment}{A vector of 0s and 1s corresponding to treatment indicator. 1 = treated, Same length as baseline}

\item{conf.level}{confidence level of the interval}

\item{delta}{A numeric between 0 and 1 OR the string "estimate" (the default). The proportion of observation treated.}
}
\description{
In a typical pretest-posttest RCT, subjects are randomized to two treatments, and response is measured at baseline,
prior to intervention with the randomized treatment (pretest), and at prespecified follow-up time (posttest).
Interest focuses on the effect of treatments on the change between mean baseline and follow-up response.
Missing posttest response for some subjects is routine, and disregarding missing cases can lead to invalid inference.
}
\examples{
# From Altman
expo = c(rep(1,9),rep(0,7))
bp1w = c(137,120,141,137,140,144,134,123,142,139,134,136,151,147,137,149)
bp_base = c(147,129,158,164,134,155,151,141,153,133,129,152,161,154,141,156)
diff = bp1w-bp_base
prepost.test(bp_base, bp1w, expo)

}
\references{
Marie Davidian, Anastasios A. Tsiatis and Selene Leon (2005).
"Semiparametric Estimation of Treatment Effect in a Pretest-Posttest Study
with Missing Data". Statistical Science 20, 261-301.
}
\seealso{
\code{\link{chisq.test}}
}
\author{
Claus Ekstrom \email{ekstrom@sund.ku.dk}
}
\keyword{htest}
