% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{onemargintest}
\alias{onemargintest}
\title{Two-sided table test with fixed margins}
\usage{
onemargintest(x, B = 10000L)
}
\arguments{
\item{x}{A matrix representing the contingency table.}

\item{B}{The number of simulations used to compute the p-value.}
}
\value{
A list of class "htest" giving the simulation results.
}
\description{
Test in a two-way contingency table with the row margin fixed.
}
\details{
Simulation is done by random sampling from the set of all tables with given row marginals, and works only if the marginals are strictly positive. Continuity correction is never used, and the statistic is quoted without it.
}
\examples{

m <- matrix(c(12, 4, 8, 6), 2)
chisq.test(m)
chisq.test(m, correct=FALSE)
fisher.test(m)
onemargintest(m)

m2 <- matrix(c(9, 3, 3, 7), 2)
chisq.test(m2, simulate.p.value=TRUE)
fisher.test(m2)
onemargintest(m2)

}
\author{
Claus Ekstrom <claus@rprimer.dk>
}
