% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCsummary.R
\name{MCMCsummary}
\alias{MCMCsummary}
\title{Summary function for MCMC output}
\usage{
MCMCsummary(object, params = "all", excl = NULL, digits = 2,
  Rhat = TRUE)
}
\arguments{
\item{object}{Object containing MCMC output. See DETAILS below.}

\item{params}{Character string (or vector of character strings) denoting parameters to be
returned in summary output. Partial names may be used to return all parameters containing
that set of characters.

Default \code{'all'} returns all parameters in summary output.}

\item{excl}{Character string (or vector of character strings) denoting parameters to exclude.
Partial names may be used to exclude all parameters containing that set of characters. Used in
conjunction with \code{params} argument to select parameters of interest.}

\item{digits}{Number of digits to include for posterior summary. Values will be rounded to the specified
number of digits.
Default is \code{digits = 2}.}

\item{Rhat}{If \code{TRUE}, summary information contains Gelman-Rubin convergence statistic (Rhat)
and if \code{FALSE}, Rhat output is masked.}
}
\value{
Function returns summary information (including parameter posterior mean, 2.5\% quantile, median, 97.5\%
 quantile, and Gelman-Rubin convergence statistic (Rhat)) for specified parameters.
}
\description{
Extract summary information from MCMC output (mean, median, quantiles, and Gelman-Rubin convergence statistic)
for specific parameters of interest.
}
\section{Details}{

\code{object} argument can be a \code{stanfit} object (\code{rstan} package), an \code{mcmc.list} object
(\code{coda} package), an \code{R2jags} model object (\code{R2jags} package), or a matrix containing MCMC
chains (each column representing MCMC output for a single parameter, rows representing iterations in the chain).
The function automatically detects the object type and proceeds accordingly.
}

\section{Notes}{


For \code{mcmc.list} objects, Gelman-Rubin convergence statistic (Rhat) is calculated using the
\code{gelman.diag} function in the \code{coda} package.
}
\examples{
#Load data
data(MCMC_data)

#Summary information for MCMC output
MCMCsummary(MCMC_data)

#Just 'beta' parameters
MCMCsummary(MCMC_data, params= 'beta')

#Just 'beta[1]', 'gamma[4]', and 'alpha[3]'
MCMCsummary(MCMC_data, params= c('beta[1]', 'gamma[4]', 'alpha[3]'))

}

