% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.functions.R
\name{cumrank}
\alias{cumrank}
\title{Plot cumulative ranking curves from MBNMA models}
\usage{
cumrank(x, sucra = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{"mb.rank"} generated by \code{rank.mbnma()}}

\item{sucra}{A logical object to indicate whether Surface Under Cumulative Ranking Curve (SUCRA)
values should be calculated and returned as a data frame. Areas calculated
using trapezoid approach.}

\item{...}{Arguments to be sent to \code{ggplot::geom_line()}}
}
\value{
Line plots showing the cumulative ranking probabilities for each agent/class for
the ranked dose response paramtere in \code{x}. The object returned is a list which contains the plot
(an object of \verb{class(c("gg", "ggplot")}) and a data frame of SUCRA values
if \code{sucra = TRUE}.
}
\description{
Plot cumulative ranking curves from MBNMA models
}
\examples{
\donttest{
# Using the alogliptin data
network <- mb.network(alog_pcfb)

# Estimate rankings  from an Emax dose-response MBNMA
emax <- mb.run(network, fun=temax())
ranks <- rank(emax, param=c("emax"))

# Plot cumulative rankings for both dose-response parameters simultaneously
# Note that SUCRA values are also returned
cumrank(ranks)
}
}
