% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inconsistency.functions.R
\name{drop.comp}
\alias{drop.comp}
\title{Drop treatments from multi-arm (>2) studies for node-splitting}
\usage{
drop.comp(ind.df, drops, comp, start = stats::rbinom(1, 1, 0.5))
}
\arguments{
\item{ind.df}{A data frame in long format (one arm per row) from which to drop treatments}

\item{drops}{A vector of study identifiers from which to drop treatments}

\item{comp}{A numeric vector of length 2 that contains treatment codes corresponding to the comparison
for node-splitting}

\item{start}{Can take either \code{0} or \code{1} to indicate whether to drop the treatment
in \code{comp[1]} (\code{0}) or \code{comp[2]} (\code{1})}
}
\description{
Drops arms in a way which preserves connectivity and equally removes
data from each treatment in a nodesplit comparison (so as to maximise precision)
}
