% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_08_DE_1_2_CompareValues_PSI.R
\name{CompareValues.PSI}
\alias{CompareValues.PSI}
\title{Differential splicing analysis}
\usage{
CompareValues.PSI(
  MarvelObject,
  cell.group.g1,
  cell.group.g2,
  downsample = FALSE,
  seed = 1,
  min.cells = 25,
  pct.cells = NULL,
  method,
  nboots = 1000,
  n.permutations = 1000,
  method.adjust = "fdr",
  event.type,
  show.progress = TRUE,
  annotate.outliers = TRUE,
  n.cells.outliers = 10,
  assign.modality = TRUE
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{TransformExpValues} function.}

\item{cell.group.g1}{Vector of character strings. Cell IDs corresponding to Group 1 (reference group).}

\item{cell.group.g2}{Vector of character strings. Cell IDs corresponding to Group 2.}

\item{downsample}{Logical value. If set to \code{TRUE}, the number of cells in each cell group will be downsampled to the sample size of the smaller cell group so that both cell groups will have the sample size prior to differential expression analysis. Default is \code{FALSE}.}

\item{seed}{Numeric value. The seed number for the random number generator to ensure reproducibility during during down-sampling of cells when \code{downsample} set to \code{TRUE}, during permutation testing when \code{method} set to \code{"permutation"}, and during modality assignment which will be performed automatically.}

\item{min.cells}{Numeric value. The minimum no. of cells expressing the splicing event for the event to be included for differential splicing analysis.}

\item{pct.cells}{Numeric value. The minimum percentage of cells expressing the splicing event for the event to be included for differential splicing analysis. If \code{pct.cells} is specified, then \code{pct.cells} will be used as threshold instead of \code{min.cells}.}

\item{method}{Character string. Statistical test to compare the 2 groups of cells. \code{"ks"}, \code{"kuiper"}, \code{"ad"}, \code{"dts"}, \code{"wilcox"}, \code{"t.test"}, and \code{"permutation"} for Kolmogorov-Smirnov, Kuiper, Anderson-Darling, DTS, Wilcox, t-test, and, permutation approach respectively.}

\item{nboots}{Numeric value. When \code{method} set to \code{"dts"}, the number of bootstrap iterations for computing the p-value.}

\item{n.permutations}{Numeric value. When \code{method} set to \code{"permutation"}, this argument indicates the number of permutations to perform for generating the null distribution for subsequent p-value inference. Default is \code{1000} times.}

\item{method.adjust}{Character string. Adjust p-values for multiple testing. Options available as per \code{p.adjust} function.}

\item{event.type}{Character string. Indicate which splicing event type to include for analysis. Can take value \code{"SE"}, \code{"MXE"}, \code{"RI"}, \code{"A5SS"}, or \code{"A3SS"} which represents skipped-exon (SE), mutually-exclusive exons (MXE), retained-intron (RI), alternative 5' splice site (A5SS), and alternative 3' splice site (A3SS), respectively.}

\item{show.progress}{Logical value. If set to \code{TRUE}, progress bar will be displayed so that users can estimate the time needed for differential analysis. Default value is \code{TRUE}.}

\item{annotate.outliers}{Numeric value. When set to \code{TRUE}, statistical difference in PSI values between the two cell groups that is driven by outlier cells will be annotated.}

\item{n.cells.outliers}{Numeric value. When \code{annotate.outliers} set to \code{TRUE}, the minimum number of cells with non-1 or non-0 PSI values for included-to-included or excluded-to-excluded modality change, respectively. The p-values will be re-coded to 1 when both cell groups have less than this minimum number of cells. This is to avoid false positive results.}

\item{assign.modality}{Logical value. If set to \code{TRUE} (default), modalities will be assigned to each cell group.}
}
\value{
An object of class data frame containing the output of the differential splicing analysis.
}
\description{
Performs differentially splicing analysis between 2 groups of cells.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

# Define cell groups for analysis
df.pheno <- marvel.demo$SplicePheno
cell.group.g1 <- df.pheno[which(df.pheno$cell.type=="iPSC"), "sample.id"]
cell.group.g2 <- df.pheno[which(df.pheno$cell.type=="Endoderm"), "sample.id"]

# DE
results <- CompareValues.PSI(MarvelObject=marvel.demo,
                             cell.group.g1=cell.group.g1,
                             cell.group.g2=cell.group.g2,
                             min.cells=5,
                             method="t.test",
                             method.adjust="fdr",
                             event.type=c("SE", "MXE", "RI", "A5SS", "A3SS", "AFE", "ALE"),
                             show.progress=FALSE
                             )

# Check output
head(results)
}
