% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_08_DE_1_5_SubsetCrypticA3SS.R
\name{SubsetCrypticA3SS}
\alias{SubsetCrypticA3SS}
\title{Differential gene expression analysis for differentially spliced genes}
\usage{
SubsetCrypticA3SS(MarvelObject, method, distance.to.ss = c(1, 100))
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{TransformExpValues} function.}

\item{method}{Vector of character string(s). To include splicing events from these method(s) for differential splicing analysis.}

\item{distance.to.ss}{Character string. Range of distances between A3SS and canonical splice site to consider A3SS to be cryptic. Default value \code{c(1, 100)}.}
}
\value{
An object of class S3 updated slot \code{MarvelObject$DE$PSI$Table} and new slot \code{MarvelObject$DE$PSI$A3SS.dist.to.ss}.
}
\description{
Performs differential gene expression analysis between 2 groups of cells only on differentially spliced genes.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- SubsetCrypticA3SS(MarvelObject=marvel.demo,
                                 method="ad",
                                 distance.to.ss=c(1,100)
                                 )

# Check output
head(marvel.demo$DE$PSI$Table[["ad"]])
}
