% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_08_DE_5_2_IsoSwitch_PlotExpr.R
\name{IsoSwitch.PlotExpr}
\alias{IsoSwitch.PlotExpr}
\title{Plot gene-splicing relative change}
\usage{
IsoSwitch.PlotExpr(MarvelObject, anno = FALSE)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CompareValues.Genes.10x} function.}

\item{anno}{Logical value. If set to \code{TRUE}, genes with coordinated, opposing or complex change relative to splicing change will be annotated on the plot. Default value is \code{FALSE}.}
}
\value{
An object of class S3 containing with new slots \code{MarvelObject$DE$Cor$PSIvsExpr$Plot}.
}
\description{
Plots delta PSI vs gene log2-fold change
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- IsoSwitch.PlotExpr(MarvelObject=marvel.demo, anno=TRUE)

# Check output
marvel.demo$DE$Cor$PSIvsExpr$Plot
}
