% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_09_PREDICT_NMD_8_AnnoVolcanoPlot.R
\name{AnnoVolcanoPlot}
\alias{AnnoVolcanoPlot}
\title{Annotate volcano plot with nonsense-mediated decay (NMD) genes}
\usage{
AnnoVolcanoPlot(
  MarvelObject,
  anno = FALSE,
  anno.gene_short_name = NULL,
  label.size = NULL,
  point.size = 1,
  xlabel.size = 8
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CompareExpr} function.}

\item{anno}{Logical value. If set to \code{TRUE}, selected gene names will be annotated on the plot as defined in \code{gene.label.x.below} and \code{gene.label.y.above}.}

\item{anno.gene_short_name}{Vector of character strings. When \code{anno} set to \code{TRUE}, the gene names to annotate on the plot.}

\item{label.size}{Numeric value. When \code{anno} set to \code{TRUE}, the size of gene labels.}

\item{point.size}{Numeric value. Size of data points. Default value is \code{1}.}

\item{xlabel.size}{Numeric value. Font size of the xtick labels. Default is \code{8}.}
}
\value{
An object of class S3 with new slots \code{MarvelObject$NMD$AnnoVolcanoPlot$Table} and \code{MarvelObject$NMD$AnnoVolcanoPlot$Plot}.
}
\description{
Annotate volcano plot generated from differential gene expression analysis with genes predicted to undergo splicing-induced NMD.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- AnnoVolcanoPlot(MarvelObject=marvel.demo)

# Check outputs
head(marvel.demo$NMD$AnnoVolcanoPlot$Table)
marvel.demo$NMD$AnnoVolcanoPlot$Plot
}
