% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_00_CreateMarvelObject.R
\name{CreateMarvelObject}
\alias{CreateMarvelObject}
\title{Create Marvel Object}
\usage{
CreateMarvelObject(SplicePheno = NULL, SpliceJunction = NULL,
  SpliceFeature = NULL, SpliceFeatureValidated = NULL, PSI = NULL,
  GenePheno = NULL, GeneFeature = NULL, Exp = NULL)
}
\arguments{
\item{SplicePheno}{Data frame containing sample metadata. This object should consist of at least 2 columns. Mandatory columns are \code{sample.id} and \code{cell.type}. \code{sample.id} indicates all unique sample IDs. \code{cell.type} indicates the group names of each sample. Additional columns, if present, may contain additional details of each sample such sequencing QC details etc..}

\item{SpliceJunction}{Data frame containing splice junction counts. First column should be named \code{coord.intron} and indicate the splice junction position in the form of chr:start:end. Subsequent columns should contain the splice junction counts for each sample. These junctions can be detected using external softwares such as STAR, featureCounts etc..}

\item{SpliceFeature}{List containing splicing event metadata. Each element in the list is a data frame for each splicing event type, i.e. SE, MXE, RI, A5SS, and A3SS. Names of each element should reflect the splicing event type. Mandatory columns in each data frame are \code{tran_id} and \code{gene_id}. \code{tran_id} indicates all the splicing event coordinates. These events can be detected using external softwares such as rMATS, MISO, BRIE etc.. Other columns, if present, may contain additional details of each splicing event such as gene name, gene type etc..}

\item{SpliceFeatureValidated}{List containing validated splicing event metadata. Required when \code{SpliceFeature} and \code{SpliceJunction} not specified. Each element in the list is a data frame for each splicing event type, i.e. SE, MXE, RI, A5SS, and A3SS. Names of each element should reflect the splicing event type. Mandatory columns in each data frame are \code{tran_id} and \code{gene_id}. \code{tran_id} indicates all the splicing event coordinates. These events can be detected using external softwares such as rMATS, MISO, BRIE etc.. Additional columns, if present, may contain additional details of each splicing event such as gene name, gene type etc..}

\item{PSI}{Data frame containing pre-computed PSI values. Required when \code{SpliceFeature} and \code{SpliceJunction} not specified. The first column should be named \code{tran_id} and second column onwards should be sample names containing the PSI values.}

\item{GenePheno}{Data frame containing sample metadata. Optional but highly recommended. This object should consist of at least 2 columns. Mandatory columns are \code{sample.id} and \code{cell.type}. \code{sample.id} indicates all unique sample IDs. \code{cell.type} indicates the group names of each sample. Additional columns, if present, may contain additional details of each sample such sequencing QC details etc..}

\item{GeneFeature}{Data frame containing the gene metadata. Optional but highly recommended. Mandatory column is \code{gene_id}. Additional columns, if present, may contain details of each gene, e.g. gene name, gene type etc..}

\item{Exp}{Data frame containing normalised and log-transformed gene expression values. Optional but highly recommended. The first column should be named \code{gene_id} and second column onwards should be sample names containing the gene expression values.}
}
\value{
An object of class S3. Each slot in the object is named after the \code{CreateMarvelObject} arguments.
}
\description{
\code{CreateMarvelObject} creates an S3 object named \code{Marvel} for downstream analysis.
}
\details{
This function creates an S3 object named \code{Marvel} for downstream analysis. It can take both splicing and gene expression data. Gene expression data is highly encouraged so that users can compare and contrast splicing and gene expression profiles using other functionalities by \code{MARVEL}.
}
\examples{
path_to_file <- system.file("extdata/Data", "SJ_phenoData.txt", package="MARVEL")
df.pheno <- read.table(path_to_file, sep="\\t", header=TRUE, stringsAsFactors=FALSE,
            na.strings="NA")

# Read splice junction file
path_to_file <- system.file("extdata/Data", "SJ_phenoData.txt", package="MARVEL")
sj <- read.table(paste(path_to_file), sep="\\t", header=TRUE, stringsAsFactors=FALSE,
                 na.strings="NA")

# Read splicing event metadata file
df.feature.list <- list()

path_to_file <- system.file("extdata/Data", "SE_featureData.txt", package="MARVEL")
df.feature.list[[1]] <- read.table(paste(path_to_file), sep="\\t", header=TRUE,
                        stringsAsFactors=FALSE, na.strings="NA")

names(df.feature.list) <- "SE"

# Create MARVEL object
marvel <- CreateMarvelObject(SplicePheno=df.pheno,
                             SpliceJunction=sj,
                             SpliceFeature=df.feature.list
                             )

class(marvel)
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
