% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{PDGPlot}
\alias{PDGPlot}
\title{Plot of a PDG and Data with Standard Error Bars}
\usage{
PDGPlot(data, mcl_matrix, OG = "NONE", species_colname, data_colname,
  xlab = "Taxa", ylab = "Data", ylimit = NULL, tree = NULL,
  order = NULL, main_title = NULL)
}
\arguments{
\item{data}{R object of phenotype data}

\item{mcl_matrix}{AnalyzeOrthoMCL output}

\item{OG}{optional parameter, a string with the name of chosen group (OG) to be colored}

\item{species_colname}{name of column in phenotypic data file with taxa designations}

\item{data_colname}{name of column in phenotypic data file with data observations}

\item{xlab}{string to label barplot's x axis}

\item{ylab}{string to label barplot's y axis}

\item{ylimit}{optional parameter to limit y axis}

\item{tree}{optional parameter (defaults to NULL) Path to tree file, orders the taxa by phylogenetic distribution, else it defaults to alphabetical}

\item{order}{vector with order of taxa names for across the x axis (defaults to alpha ordering)}

\item{main_title}{string for title of the plot (defaults to OG)}
}
\value{
a barplot with taxa vs phenotypic data complete with standard error bars
}
\description{
Bar plot of PDG vs phenotype data with presence of taxa in PDG indicated by color
}
\examples{

PDGPlot(pheno_data, mcl_mtrx, 'OG5_126778', 'Treatment', 'RespVar', ylimit=12)

}
