% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\name{ExampleData.DeValues}
\alias{ExampleData.DeValues}
\title{Example De data sets for the package Luminescence}
\format{
A \link{list} with two elements, each containing a two column \link{data.frame}:

\describe{
\verb{$BT998}: De and De error values for a fine grain quartz
sample from a loess section in Rottewitz.

\verb{$CA1}: Single grain De
and De error values for a coarse grain quartz sample from a fluvial deposit
in the rock shelter of Cueva Anton
}
}
\description{
Equivalent dose (De) values measured for a fine grain quartz sample from a
loess section in Rottewitz (Saxony/Germany) and for a coarse grain quartz
sample from a fluvial deposit in the rock shelter of Cueva Anton
(Murcia/Spain).
}
\examples{

##(1) plot values as histogram
data(ExampleData.DeValues, envir = environment())
plot_Histogram(ExampleData.DeValues$BT998, xlab = "De [s]")

##(2) plot values as histogram (with second to gray conversion)
data(ExampleData.DeValues, envir = environment())

De.values <- convert_Second2Gray(ExampleData.DeValues$BT998,
                         dose.rate = c(0.0438, 0.0019))


plot_Histogram(De.values, xlab = "De [Gy]")

}
\references{
\strong{BT998}

Unpublished data

\strong{CA1}

Burow, C., Kehl, M., Hilgers, A., Weniger, G.-C., Angelucci, D., Villaverde,
V., Zapata, J. and Zilhao, J.  (2015). Luminescence dating of fluvial
deposits in the rock shelter of Cueva Anton, Spain. Geochronometria 52, 107-125.

\strong{BT998}

\tabular{ll}{
Lab: \tab Luminescence Laboratory Bayreuth\cr
Lab-Code: \tab BT998\cr
Location: \tab Rottewitz (Saxony/Germany)\cr
Material: \tab Fine grain quartz measured on aluminium discs on a Risø TL/OSL DA-15 reader\cr
Units: \tab Values are given in seconds \cr
Dose Rate: \tab Dose rate of the beta-source at measurement ca. 0.0438 Gy/s +/- 0.0019 Gy/s\cr
Measurement Date: \tab 2012-01-27
}

\strong{CA1}

\tabular{ll}{
Lab: \tab Cologne Luminescence Laboratory (CLL)\cr
Lab-Code: \tab C-L2941\cr
Location: \tab Cueva Anton (Murcia/Spain)\cr
Material: \tab Coarse grain quartz (200-250 microns) measured on single grain discs on a Risoe TL/OSL DA-20 reader\cr
Units: \tab Values are given in Gray \cr
Measurement Date: \tab 2012
}
}
\keyword{datasets}
