% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot_Risoe.BINfileData.R
\name{plot_Risoe.BINfileData}
\alias{plot_Risoe.BINfileData}
\title{Plot single luminescence curves from a BIN file object}
\usage{
plot_Risoe.BINfileData(BINfileData, position, run, set, sorter = "POSITION",
  ltype = c("IRSL", "OSL", "TL", "RIR", "RBR", "RL"), curve.transformation,
  dose_rate, temp.lab, cex.global = 1, ...)
}
\arguments{
\item{BINfileData}{\link{Risoe.BINfileData-class} (\bold{required}):
requires an S4 object returned by the \link{readBIN2R} function.}

\item{position}{\link{vector} (optional): option to limit the plotted curves
by position (e.g. \code{position = 1}, \code{position = c(1,3,5)}).}

\item{run}{\link{vector} (optional): option to limit the plotted curves by
run (e.g., \code{run = 1}, \code{run = c(1,3,5)}).}

\item{set}{\link{vector} (optional): option to limit the plotted curves by
set (e.g., \code{set = 1}, \code{set = c(1,3,5)}).}

\item{sorter}{\link{character} (with default): the plot output can be
ordered by "POSITION","SET" or "RUN". POSITION, SET and RUN are options
defined in the Risoe Sequence Editor.}

\item{ltype}{\link{character} (with default): option to limit the plotted
curves by the type of luminescence stimulation.  Allowed values:
\code{"IRSL"}, \code{"OSL"},\code{"TL"}, \code{"RIR"}, \code{"RBR"}
(corresponds to LM-OSL), \code{"RL"}.  All type of curves are plotted by
default.}

\item{curve.transformation}{\link{character} (optional): allows transforming
CW-OSL and CW-IRSL curves to pseudo-LM curves via transformation functions.
Allowed values are: \code{CW2pLM}, \code{CW2pLMi}, \code{CW2pHMi} and
\code{CW2pPMi}. See details.}

\item{dose_rate}{\link{numeric} (optional): dose rate of the irradition
source at the measurement date. If set, the given irradiation dose will be
shown in Gy.  See details.}

\item{temp.lab}{\link{character} (optional): option to allow for different
temperature units. If no value is set deg. C is chosen.}

\item{cex.global}{\link{numeric} (with default): global scaling factor.}

\item{\dots}{further undocumented plot arguments.}
}
\value{
Returns a plot.
}
\description{
Plots single luminescence curves from an object returned by the
\link{readBIN2R} function.
}
\details{
\bold{Nomenclature}\cr

See \code{\link{Risoe.BINfileData-class}}

\bold{curve.transformation}\cr

This argument allows transforming continuous wave (CW) curves to pseudo
(linear) modulated curves. For the transformation, the functions of the
package are used.  Currently, it is not possible to pass further arguments
to the transformation functions. The argument works only for \code{ltype}
\code{OSL} and \code{IRSL}.\cr

\bold{Irradiation time}\cr

Plotting the irradiation time (s) or the given dose (Gy) requires that the
variable \code{IRR_TIME} has been set within the BIN-file.  This is normally
done by using the 'Run Info' option within the Sequence Editor or by editing
in R.
}
\note{
The function has been successfully tested for the Sequence Editor file
output version 3 and 4.
}
\section{Function version}{
 0.4.1 (2015-04-30 12:00:00)
}
\examples{
##load data
data(ExampleData.BINfileData, envir = environment())

##plot all curves from the first position to the desktop
#pdf(file = "~/Desktop/CurveOutput.pdf", paper = "a4", height = 11, onefile = TRUE)

##example - load from *.bin file
#BINfile<- file.choose()
#BINfileData<-readBIN2R(BINfile)

#par(mfrow = c(4,3), oma = c(0.5,1,0.5,1))
#plot_Risoe.BINfileData(CWOSL.SAR.Data,position = 1)
#mtext(side = 4, BINfile, outer = TRUE, col = "blue", cex = .7)
#dev.off()
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France),\cr Michael Dietze, GFZ Potsdam (Germany)
\cr R Luminescence Package Team}
\references{
Duller, G., 2007. Analyst. pp. 1-45.
}
\seealso{
\code{\link{Risoe.BINfileData-class}},\code{\link{readBIN2R}},
\code{\link{CW2pLM}}, \code{\link{CW2pLMi}}, \code{\link{CW2pPMi}},
\code{\link{CW2pHMi}}
}
\keyword{dplot}

