% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizeResults.R
\name{organizeResults}
\alias{organizeResults}
\title{Prepare output for LipidMS annotation functions}
\usage{
organizeResults(candidates, clfrags, classConf, chainComb, intrules, intConf,
  nchains, class)
}
\arguments{
\item{candidates}{candidates data frame. Output of \link{findCandidates}.}

\item{clfrags}{vector containing the expected fragments for a given lipid
class.}

\item{classConf}{output of \link{checkClass}}

\item{chainComb}{output of \link{combineChains}}

\item{intrules}{character vector specifying the fragments to compare. See
\link{checkIntensityRules}.}

\item{intConf}{output of \link{checkIntensityRules}}

\item{nchains}{number of chains of the targeted lipid class.}

\item{class}{character value. Lipid class (i.e. PC, PE, DG, TG, etc.).}
}
\description{
Prepare a readable output for LipidMS identification functions.
}
\examples{
\donttest{
dbs <- list(pgdb = LipidMS::pgdb, lysopgdb = LipidMS::lysopgdb,
fadb = LipidMS::fadb, adductsTable = LipidMS::adductsTable)

candidates <- findCandidates(MS1 = LipidMS::mix_neg_fullMS, dbs[["pgdb"]],
ppm = 10, rt = c(min(MS1$RT), max(MS1$RT)), adducts = c("M-H"),
rttol = 3, dbs)

MSMS <- rbind(LipidMS::mix_neg_Ce20, LipidMS::mix_neg_Ce40)
coelfrags <- coelutingFrags(candidates$RT, MSMS, rttol)

classConf <- checkClass(candidates, clfrags = c(227.0326, 209.022, 74.0359),
clrequired = c(F, F, F, F), ftype = c("F", "F", "NL"), ppm_products = 10,
dbs)

sn1 <- chainFrags(coelfrags, chainfrags = c("lysopg_M-H"), ppm = 10,
dbs = dbs)
sn2 <- chainFrags(coelfrags, chainfrags = c("fa_M-H"), ppm = 10, dbs)

chainsComb <- combineChains(candidates, nchains=2, sn1, sn2)

intConf <- checkIntensityRules(intrules = c("lysopg_sn1/lysopg_sn1"),
rates = c("2/1"), intrequired = c(T), nchains=2, chainsComb, sn1, sn2)

res <- organizeResults(candidates, clfrags = c(227.0326, 209.022, 74.0359),
classConf, chainsComb, intrules = c("lysopg_sn1/lysopg_sn1"), intConf,
nchains = 2, class="PG")
}


}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
