% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getInclusionList.R
\name{getInclusionList}
\alias{getInclusionList}
\title{Obtain an inclusion list from the annotation results}
\usage{
getInclusionList(results, adductsTable = LipidMS::adductsTable)
}
\arguments{
\item{results}{data frame. Output of identification functions.}

\item{adductsTable}{data frame with the adducts allowed and their mass
difference.}
}
\value{
Data frame with 6 columns: formula, RT, neutral mass, m/z, adduct
and the compound name.
}
\description{
Obtain an inclusion list from the annotation results.
}
\examples{
\donttest{results <- idPOS(LipidMS::serum_pos_fullMS, LipidMS::serum_pos_Ce20,
LipidMS::serum_pos_Ce40)
getInclusionList(results$results)}

}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
