% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EXPLindley.R
\name{EXPLindley}
\alias{EXPLindley}
\alias{dexplindley}
\alias{hexplindley}
\alias{pexplindley}
\alias{qexplindley}
\alias{relieftimes}
\alias{rexplindley}
\title{Exponentiated Lindley Distribution}
\source{
[d-h-p-q-r]explindley are calculated directly from the definitions. \code{rexplindley} uses the quantile function.
}
\usage{
dexplindley(x, theta, alpha, log = FALSE)

pexplindley(q, theta, alpha, lower.tail = TRUE, log.p = FALSE)

qexplindley(p, theta, alpha, lower.tail = TRUE, log.p = FALSE)

rexplindley(n, theta, alpha)

hexplindley(x, theta, alpha, log = FALSE)
}
\arguments{
\item{x, q}{vector of positive quantiles.}

\item{theta, alpha}{positive parameters.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq x)} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dexplindley} gives the density, \code{pexplindley} gives the distribution function, \code{qexplindley} gives the quantile function, \code{rexplindley} generates random deviates and \code{hexplindley} gives the hazard rate function.

Invalid arguments will return an error message.
}
\description{
Density function, distribution function, quantile function, random number generation and hazard rate function for the exponentiated Lindley distribution with parameters theta and alpha.
}
\details{
Probability density function
\deqn{f(x\mid \theta,\alpha )=\frac{\alpha \theta ^{2}}{(1+\theta )} (1+x)e^{-\theta x}\left[ 1-\left( 1+\frac{\theta x}{1+\theta }\right) e^{-\theta x}\right] ^{\alpha -1}}

Cumulative distribution function
\deqn{F(x\mid \theta,\alpha )=\left[ 1-\left( 1+\frac{\theta x}{1+\theta }\right) e^{-\theta x}\right] ^{\alpha }}

Quantile function
\deqn{Q(p\mid \theta ,\alpha )=-1-\frac{1}{\theta }-{\frac{1}{\theta }}W_{-1}{\left( (p^{\frac{1}{\alpha }}-1)\left( 1+\theta \right) e{^{-\left( 1+\theta \right) }}\right) }}

Hazard rate function
\deqn{h(x\mid \theta ,\alpha )={\frac{\alpha {\theta }^{2}\left( 1+x\right) {{e}^{-\theta x}}\left[ 1-\left( 1+{\frac{\theta x}{1+\theta }}\right) e{^{-\theta x}}\right] ^{\alpha -1}}{\left( 1+\theta \right) \left\{ 1-\left[ 1-\left( 1+\frac{\theta x}{1+\theta }\right) e^{-\theta x}\right] ^{\alpha}\right\} }}}
where \eqn{W_{-1}} denotes the negative branch of the Lambert W function.

\bold{Particular case:} \eqn{\alpha = 1} the one-parameter Lindley distribution.
}
\note{
Nadarajah et al. (2011) named the exponentiated Lindley distribution as generalized Lindley distribution.
}
\examples{
set.seed(1)
x <- rexplindley(n = 1000, theta = 1.5, alpha = 1.5)
R <- range(x)
S <- seq(from = R[1], to = R[2], by = 0.1)
plot(S, dexplindley(S, theta = 1.5, alpha = 1.5), xlab = 'x', ylab = 'pdf')
hist(x, prob = TRUE, main = '', add = TRUE)

p <- seq(from = 0.1, to = 0.9, by = 0.1)
q <- quantile(x, prob = p)
pexplindley(q, theta = 1.5, alpha = 1.5, lower.tail = TRUE)
pexplindley(q, theta = 1.5, alpha = 1.5, lower.tail = FALSE)
qexplindley(p, theta = 1.5, alpha = 1.5, lower.tail = TRUE)
qexplindley(p, theta = 1.5, alpha = 1.5, lower.tail = FALSE)

## Relief times data (from Nadarajah et al., 2011)
data(relieftimes)
library(fitdistrplus)
fit <- fitdist(relieftimes, 'explindley', start = list(theta = 1.5, alpha = 1.5))
plot(fit)

}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Larissa B. Fernandes \email{lbf.estatistica@gmail.com}
}
\references{
Nadarajah, S., Bakouch, H. S., Tahmasbi, R., (2011). A generalized Lindley distribution. \emph{Sankhya B}, \bold{73}, (2), 331-359.
}
\seealso{
\code{\link[lamW]{lambertWm1}}.
}

