% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dst.R
\name{dst_change_summary}
\alias{dst_change_summary}
\title{Get a summary of groups where a daylight saving time change occurs.}
\usage{
dst_change_summary(dataset, Datetime.colname = Datetime)
}
\arguments{
\item{dataset}{dataset to be summarized, must be a \code{dataframe}}

\item{Datetime.colname}{name of the column that contains the Datetime data, expects a \code{symbol}}
}
\value{
a \code{tibble} with the groups where a dst change occurs. The column \code{dst_start} is a boolean that indicates whether the start of this group occurs during daylight savings.
}
\description{
Get a summary of groups where a daylight saving time change occurs.
}
\examples{
sample.data.environment \%>\% 
  dplyr::mutate(Datetime = 
  lubridate::with_tz(Datetime, "Europe/Berlin") + lubridate::dweeks(10)) \%>\%
  dst_change_summary()
}
\seealso{
Other DST: 
\code{\link{dst_change_handler}()}
}
\concept{DST}
