% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationHC.details.R
\name{correlationHC.details}
\alias{correlationHC.details}
\title{To explain how hierarchical correlation algorithm works.}
\usage{
correlationHC.details(
  data,
  target = NULL,
  weight = c(),
  distance = "EUC",
  normalize = TRUE,
  labels = NULL
)
}
\arguments{
\item{data}{is a data frame with the main data.}

\item{target}{is a data frame , a numeric vector or a matrix. Default value = NULL.}

\item{weight}{is a numeric vector. Default value = empty vector.}

\item{distance}{is a string. The distance type. Default value = Euclidean distance.}

\item{normalize}{is a boolean parameter. If the user wants to normalize weights. Default value = TRUE.}

\item{labels}{is a string vector. For the graphical solution. Default value = NULL.}
}
\value{
R object with a dendrogram, the sorted distances and the list with every cluster. Explanation.
}
\description{
To explain how the hierarchical correlation algorithm works.
}
\details{
This function explains the complete hierarchical correlation method.
It explains the theoretical algorithm step by step.

1 - The function transforms data in useful object to be used.

2 - It creates the clusters.

3 - It calculates the distance from the target to every cluster applying the distance type given.

4 - It orders the distance in an increasing way.

5 - It orders the clusters according to their distance from the previous step

6 - It shows the clusters sorted and the distance used.
}
\examples{

data <- matrix(c(1,2,1,4,5,1,8,2,9,6,3,5,8,5,4),ncol= 3)

dataFrame <- data.frame(data)

target1 <- c(1,2,3)

target2 <- dataFrame[1,]

weight1 <- c(1,6,3)

weight2 <- c(0.1,0.6,0.3)

correlationHC.details(dataFrame, target1)

correlationHC.details(dataFrame, target1, weight1)

correlationHC.details(dataFrame, target1, weight1, normalize = FALSE)

correlationHC.details(dataFrame, target1, weight2, 'CAN', FALSE)

}
\author{
Roberto Alcántara \email{roberto.alcantara@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
