% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploratory.R
\name{Yule}
\alias{Yule}
\title{Yule coefficient of correlation}
\usage{
Yule(x, Y = FALSE)
}
\arguments{
\item{x}{a 1 x 4 vector or a matrix 2 x 2 of frequencies.}

\item{Y}{if Y is true return Yule's Y coefficient of colligation.}
}
\value{
the value of the Yule Q coefficient.
}
\description{
The Yule coefficientis a correlation coefficient applied 
to dichotomous data. Given a two x two table of counts\cr
| a | b | R1 |\cr
| c | d | R1 |\cr
|---|---|----|\cr
|C1 | C2| n  |\cr
or a vector c(a,b,c,d) of frequencies. Taken from psych::Yule.
}
\details{
The coefficient of Yule is calculated from (ad - bc)/(ad + bc).
This is the number of pairs in agreement (ad) - the number in disagreement (bc) 
over the total number of paired observations.
}
\references{
Yule, G.U. (1912). On the methods of measuring the association between two attributes. Journal of the Royal Statistical Society, 75, 579-652.

Warrens, Matthijs (2008), On Association Coefficients for 2x2 Tables and Properties That Do Not Depend on the Marginal Distributions. Psychometrika, 73, 777-789.
}

