% Generated by roxygen2 (4.0.2): do not edit by hand
\name{delta_GMM}
\alias{delta_GMM}
\title{Estimate optimal delta}
\usage{
delta_GMM(z, type = c("h", "hh"), kurtosis.x = 3, skewness.x = 0,
  delta.init = delta_Taylor(z), tol = .Machine$double.eps^0.25,
  not.negative = FALSE, optim.fct = c("nlm", "optimize"), lower = -1,
  upper = 3)
}
\arguments{
\item{z}{a numeric vector of data values.}

\item{type}{type of Lambert W \eqn{\times} F distribution: skewed \code{"s"};
heavy-tail \code{"h"}; or skewed heavy-tail \code{"hh"}.}

\item{kurtosis.x}{theoretical kurtosis of the input X; default: \code{3}
(\eqn{X \sim} Gaussian).}

\item{skewness.x}{theoretical skewness of the input X. Only used if \code{type = "hh"};
default: \code{0} (\eqn{X \sim} symmetric).}

\item{delta.init}{starting value for optimization; default: \code{\link{delta_Taylor}}.}

\item{tol}{a positive scalar giving the tolerance at which the distance is
considered close enough to zero to terminate the algorithm; default:
\code{.Machine$double.eps^0.25}.}

\item{not.negative}{logical; if \code{TRUE} the estimate for \eqn{\delta} is
restricted to the non-negative reals. Default: \code{FALSE}.}

\item{optim.fct}{which R optimization function should be used. Either \code{'optimize'}
(only for \code{type = 'h'} and if \code{not.negative = FALSE}) or \code{'nlm'}.
Performance-wise there is no big difference.}

\item{lower,upper}{lower and upper bound for optimization if \code{optim.fct = 'optimize'}
and \code{not.negative = FALSE}. Default: \code{-1} and \code{3}
(this covers most real-world heavy-tail scenarios).}
}
\value{
A list with two elements:
\item{delta}{ optimal \eqn{\delta} for data \eqn{z}, }
\item{iterations}{number of iterations (\code{NA} for \code{'optimize'}).}
}
\description{
This function minimizes the Euclidean distance between the theoretical
kurtosis of a heavy-tail(s) Lambert W x Gaussian random variable and the sample
kurtosis of the back-transformed
data \eqn{W_{\delta}(\boldsymbol z)} as a function of \eqn{\delta} (see
References). Note that only an iterative application of this function will
give a good estimate of \eqn{\delta} (see \code{\link{IGMM}}).
}
\examples{
# very heavy-tailed (like a Cauchy)
y <- rLambertW(n = 1000, theta = list(beta = c(1, 2), delta = 1),
               distname = "normal")
delta_GMM(y) # after the first iteration
}
\seealso{
\code{\link{gamma_GMM}} for the skewed version of this function;
\code{\link{IGMM}} to estimate all parameters jointly.
}
\keyword{optimize}

