% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depths_calculation.R
\name{get_depths}
\alias{get_depths}
\title{Fuels depth in meters}
\usage{
get_depths (LAD_profiles, distance_metrics,verbose=TRUE)
}
\arguments{
\item{LAD_profiles}{original tree Leaf Area Density (LAD) profile (output of [lad.profile()] function in the \emph{leafR} package.
An object of the class text.}

\item{distance_metrics}{tree metrics with gaps (distances) and fuel base heights (output of [get_distance()] function).
An object of the class text.}

\item{verbose}{Logical, indicating whether to display informational messages (default is TRUE).}
}
\value{
A data frame giving fuel layers depth and the height of the depths in meters.
}
\description{
This function calculates fuels depth as the difference between gaps interleaved between fuel layers minus 1 if the fuel depths are greater than 1.
}
\details{
# List of tree metrics:
\itemize{
\item treeID: tree ID with strings and numeric values
\item treeID1: tree ID with only numeric values
\item cbh - Height of the fuel layers base height (m)
\item gap - Height of gaps between consecutive fuel layers (m)
\item dist: Distance between consecutive fuel layers (m)
\item Hdist - Height of the distance between consecutive fuel layers (m)
\item depth - Depth of fuel layers (m)
\item Hdepth - Height of the depth of fuel layers (m)
\item max_height - Maximum height of the tree profile
}
}
\examples{
library(magrittr)
library(dplyr)

# Before running this example, make sure to run get_distance().
if (interactive()) {
distance_metrics <- get_distance()
LadderFuelsR::LAD_profiles$treeID <- factor(LadderFuelsR::LAD_profiles$treeID)
LadderFuelsR::distance_metrics$treeID <- factor(LadderFuelsR::distance_metrics$treeID)

metrics_depth_list <- list()

for (i in levels(LAD_profiles$treeID)){

tree1 <- LAD_profiles |> dplyr::filter(treeID == i)
tree2 <- distance_metrics |> dplyr::filter(treeID == i)

# Get depths for each tree
metrics_depth <- get_depths(tree1, tree2,verbose=TRUE)
metrics_depth_list[[i]] <- metrics_depth
}

# Combine the individual data frames
depth_metrics <- dplyr::bind_rows(metrics_depth_list)
}
}
\seealso{
\code{\link{get_distance}}
}
\author{
Olga Viedma, Carlos Silva and JM Moreno
}
