% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_lucid.R
\name{boot.lucid}
\alias{boot.lucid}
\title{Bootstrap method of inference for LUCID}
\usage{
boot.lucid(G, Z, Y, CoG = NULL, CoY = NULL, model, R = 100, n = detectCores())
}
\arguments{
\item{G}{Genetic features/environmental exposures, a \code{\link{matrix}}.}

\item{Z}{Biomarkers/other omics data, a \code{\link{matrix}}.}

\item{Y}{Disease outcome, it is suggested to transform it into a n by 1 \code{\link{matrix}}.}

\item{CoG}{Optional, matrix. Covariates to be adjusted for estimating the latent cluster.}

\item{CoY}{Optional, matrix. Covariates to be adjusted for estimating the outcome.}

\item{model}{A LUCID model fitted by \code{\link{est.lucid}}.}

\item{R}{Number of bootstrap iterations.}

\item{n}{Number of CPU cores to be used in the bootstrap}
}
\value{
A list of estimates with their 95 percent CI.
}
\description{
This function provides SEs of parameter estimates from a LUCID model through bootstrap method.
}
\examples{
\dontrun{
fit1 <- est.lucid(G = sim2[, 1:10], Z = sim2[, 11:20], Y = as.matrix(sim2[, 21]), 
K = 2, family = "binary")
chk <- Sys.getenv("_R_CHECK_LIMIT_CORES_", "")
if (nzchar(chk) && chk == "TRUE") {
 # use 2 cores in CRAN/Travis/AppVeyor
 num_workers <- 2L
} else {
 num_workers <- parallel::detectCores()
}
boot1 <- boot.lucid(G = sim2[, 1:10], Z = sim2[, 11:20], Y = as.matrix(sim2[, 21]),
 model = fit1, R = 100, n = num_workers)
}
}
\references{
Cheng Peng, Jun Wang, Isaac Asante, Stan Louie, Ran Jin, Lida Chatzi, Graham Casey, Duncan C Thomas, David V Conti, A Latent Unknown Clustering Integrating Multi-Omics Data (LUCID) with Phenotypic Traits, Bioinformatics, , btz667, https://doi.org/10.1093/bioinformatics/btz667.
}
\author{
Yinqi Zhao, Cheng Peng, Zhao Yang, David V. Conti
}
